<?php
// auto_resubmit.php - intended to be run from CLI (cron)
error_reporting(E_ALL);
ini_set('display_errors', 0); // 0 for cron; set 1 for manual testing

// Include DB connection and PAN resend functions
include_once __DIR__ . "/../db_connection.php";
include_once __DIR__ . "/resend_functions1.php";

date_default_timezone_set('America/Chicago'); // Chicago timezone
$logFile = __DIR__ . '/pan_resubmit.log';
$now = date('Y-m-d H:i:s');
file_put_contents($logFile, "[$now] Cron run started\n", FILE_APPEND);

// Fetch PANs eligible for resubmission - must run every 24 hrs else fails
// $sql = "SELECT PAN_ID, FormType, branch, department
//         FROM PAN_newhires
//         WHERE Approval_Status = 'PENDING FOR APPROVAL'
//           AND (
//                 (last_resubmitted_at IS NULL AND timeStamp <= NOW() - INTERVAL 24 HOUR)
//                 OR
//                 (last_resubmitted_at IS NOT NULL AND last_resubmitted_at <= NOW() - INTERVAL 24 HOUR)
//               )";


//last_resubmitted_at IS NULL → First-time reminder (after initial 24 hrs).
// DATE(last_resubmitted_at) < CURDATE() → Hasn’t been resent today, so resend now.
$sql = "SELECT PAN_ID, FormType, branch, department
        FROM PAN_newhires
        WHERE Approval_Status = 'PENDING FOR APPROVAL'
          AND (
                last_resubmitted_at IS NULL
                OR DATE(last_resubmitted_at) < CURDATE()
              )";

$res = $conn->query($sql);
if (!$res) {
    file_put_contents($logFile, "[$now] Query failed: " . $conn->error . "\n", FILE_APPEND);
    exit(1);
}

$processed = 0;
while ($row = $res->fetch_assoc()) {
    $processed++;
    $PAN_ID = $row['PAN_ID'];
    $FormType = $row['FormType'];
    $branch = $row['branch'] ?? '';
    $department = $row['department'] ?? '';

    file_put_contents($logFile, "[$now] Attempting resend for PAN_ID $PAN_ID\n", FILE_APPEND);

    // Pass config path and secretkey if needed
    $result = resendPAN(
        $conn,
        $PAN_ID,
        $FormType,
        $secretkey, // <--- pass string, NOT array
        [
            'config_path' => __DIR__ . '/../config.php',
            'log_file'    => __DIR__ . '/resend_log.txt'
        ]
    );

    if ($result['success']) {
        // Update last_resubmitted_at
        $stmt = $conn->prepare("UPDATE PAN_newhires SET last_resubmitted_at = NOW() WHERE PAN_ID = ?");
        if ($stmt) {
            $stmt->bind_param('i', $PAN_ID);
            $stmt->execute();
            $stmt->close();
        }
        file_put_contents($logFile, "[$now] Sent OK for PAN_ID $PAN_ID to {$result['to']} (subject: {$result['subject']})\n", FILE_APPEND);
    } else {
        file_put_contents($logFile, "[$now] Send FAILED for PAN_ID $PAN_ID - Error: " . ($result['error'] ?? 'unknown') . "\n", FILE_APPEND);
    }
}

file_put_contents($logFile, "[$now] Cron finished. Processed: $processed tickets.\n\n", FILE_APPEND);
$conn->close();
