<?php
 /* ======================================================================================================================================================
 -- Author: Saquib Patwa
 -- Create date: 09/23/2019
 -- Description: Contact form for IT Help Desk/Phoenix Ticket,  HR, PAN and Facility

 -- MODIFICATION
 -- Last Modified Date: 10/07/2019 -
 -- Last Modified Date: 03/24/2021 - Added Branch and Department to IT, Phoenix & HR options
 -- Last Modified Date: 03/24/2021 - Added a button & form 'Personnel Action Notice Form'
 -- Last Modified Date: 07/07/2021 - Finished working on Personnel Action Notice Form
 -- Last Modified Date: 07/19/2021 - added attachment and some formatting changes
 -- Last Modified Date: 07/28/2021 - Added Forwarding the user's email to another radio button and employee Name to SEPARATION section of the PAN Form
 -- Last Modified Date: 09/16/2021 - Addred functionality to CHANGE & SEPARATION (radio buttons) to remove ADDRESS, CITY, STATE, ZIP & TELEPHONE
 -- Last Modified Date: 09/17/2021 - Date picker was not working on Mobile devices so corrected that for all date pickers.
 -- Last Modified Date: 09/18/2021 - Using EMAIL from endpoint for "FROMEMAIL"
 -- Last Modified Date: 02/09/2022 - Added SSN
 -- Last Modified Date: 11/28/2022 - Add a new department 'STR Parts Sales Support & Employee Development'
 -- Last Modified Date: 05/23/2023 - Add a new department 'STR Training'
 -- Last Modified Date: 12/28/2023 - Add a new department 'STR Web'
 -- Last Modified Date: 02/09/2024 - STR TRAINGING separated into 2 → Parts Training and Service Training
 -- Last Modified Date: 03/21/2024 - EMAIL SENT TO THE PERSON SUBMITTED A PAN WITHOUT THE APPROVE/REJECT LINK AND REMOVED DL FOR THE SUBMITTERS EMAIL
 -- Last Modified Date: 09/17/2024 - FACILITY REQUEST ADDED
 -- Last Modified Date: 10/08/2024 - EMAIL SENT BY COMPANY DEPARTMENT AND SHIFTS, HIERARCHY AND OTHER FIELDS ADDED
 -- Last Modified Date: 01/12/2026 - ADDED DASHBOARD TICKET REQUEST
 -- ======================================================================================================================================================= */

 // To hide all errors
 error_reporting(0);
 ini_set('display_errors', 0);

 // Prevent the page from being cached
 header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
 header("Cache-Control: post-check=0, pre-check=0", false);
 header("Pragma: no-cache");
 header("Expires: 0");


 // Using database connection file here
include_once "db_connection.php";

//For enabling and disabling the helpdesk page
include 'ToggleHelpdeskConfig.php';

// ------------------------------------------------------------------------------HELPDESK-------------------------------------------------------------------

// HELPDESK TOGGLE BUTTON TO SWITCH TO UNDERCONTRUCTION PAGE
if ($HelpdeskEnabled) {


$postData = $uploadedFile = $statusMsg = '';
$msgClass = 'errordiv';

if(isset($_POST['submit'])){

// Get the submitted form data
 // Help Desk Fields
    $postData = $_POST;
    // $name = $_POST['name'];
    $First_Name = $_POST['First_Name'];
    $Last_Name = $_POST['Last_Name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];               // callback #
    $extension = $_POST['extension'];       // Office Extension
    $workstation = $_POST['workstation'];   // Workstation #
    $employeeID = $_POST['employeeID'];
    $branch = $_POST['branch'];
    $department = $_POST['department'];
    $Building = $_POST['Building'];
    $RoomNo = $_POST['RoomNo'];
    // $subject = "Support Ticket";        // Subject hard coded
    $message = $_POST['message'];          // Message



    // Check whether submitted data is not empty
    if(!empty($email)) {

        // Validate email
        if(filter_var($email, FILTER_VALIDATE_EMAIL) === false){
            $statusMsg = 'Please enter your valid email.';
        }else{
            $uploadStatus = 1;

            // Upload attachment file
            if(!empty($_FILES["attachment"]["name"])){

                // File path config
                $targetDir = "uploads/";
                $fileName = basename($_FILES["attachment"]["name"]);
                $targetFilePath = $targetDir . $fileName;
                $fileType = strtolower(pathinfo($targetFilePath,PATHINFO_EXTENSION));

                // Allow certain file formats
                $allowTypes = array('pdf', 'doc', 'docx', 'jpg', 'png', 'jpeg', 'xls', 'xlsx', 'txt', 'msg' );
                if(in_array($fileType, $allowTypes)){
                    // Upload file to the server
                    if(move_uploaded_file($_FILES["attachment"]["tmp_name"], $targetFilePath)){
                        $uploadedFile = $targetFilePath;
                    }else{
                        $uploadStatus = 0;
                        $statusMsg = "Sorry, there was an error uploading your file.";
                    }
                }else{
                    $uploadStatus = 0;
                    $statusMsg = 'Sorry, only PDF, DOC/X, PNG, JPG, JPEG, XLS/X & txt files are allowed to upload.';
                }
            }




            if($uploadStatus == 1){

                // Recipient
                $toEmail="";

                 // TEST Emails
                  //$hrEmail= "saquib.patwa@strhouston.com";
                  //$ITemail= "saquib.patwa@strhouston.com";
                  //$phEmail= "saquib.patwa@strhouston.com";



                // Live emails
                 $hrEmail= "HRMail@selectransportation.com";
                 $ITemail= "support@strhelpdesk.zendesk.com";
                 $phEmail= "support@strhelpdesk.zendesk.com";
                 $FacEmail= "support@strfacilities.zendesk.com";
                 $DashboardEmail = "support@strhelpdesk.zendesk.com";
                 // $FacEmail= "saquib.patwa@selectransportation.com";

                 $subject="";
                 $HRsubject = "HR Support Ticket";
                 $ITsubject = "IT Support Ticket";
                 $PHsubject = "Phoenix Support Ticket";
                 $FACsubject = "Facility Request";
                 $DashboardSubject= "Dashboard Request";


                 if (isset($_POST['submit'])) {
                        switch ($_POST['submit']) {
                            case 'btnHR':
                                    $toEmail=$hrEmail;
                                    // echo $toEmail;
                                    $subject = $HRsubject;
                                    // echo $subject;
                                break;

                            case 'btnIT':
                                $toEmail=$ITemail;
                                    // echo $toEmail;
                                    $subject = $ITsubject;
                                    // echo $subject;
                                break;

                            case 'btnPH':
                                $toEmail=$phEmail;
                                    // echo $toEmail;
                                    $subject = $PHsubject;
                                    // echo $subject;
                                break;

                            case 'btnFAC':
                                $toEmail=$FacEmail;
                                // echo $toEmail;
                                $subject = $FACsubject;
                                // echo $subject;
                                break;

                            case 'btnDashboard':
                                $toEmail=$DashboardEmail;
                                // echo $toEmail;
                                $subject = $DashboardSubject;
                                // echo $subject;
                                break;
                        }
                    }


                // $fromName = $_POST['First_Name'];
                $fromName = $_POST['First_Name'] . " " . $_POST['Last_Name'] ;
                $from = $_POST['email']; // required
                // $phone = $_POST['phone'];
                // $subject =$_POST['subject'];


    $error_message = "";
    $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';

    if(preg_match('^\D?(\d{3})\D?\D?(\d{3})\D?(\d{4})*$', $_POST['phone'],  $matches ) )
    {
      $formattedphone = $matches[1] . '-' .$matches[2] . '-' . $matches[3];
      return $formattedphone;
    }


 // Parts of alternate colors to the table rows
  $rowCount = $c = 0;

   // Array of input field name
    $helpDeskSupportList = array('First_Name', 'Last_Name', 'email', 'phone', 'extension', 'workstation', 'employeeID', 'branch', 'department', 'Building', 'RoomNo', 'message');

     // Email logo, title
     $email_message =  '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px" cellpadding="10">';
     $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="https://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
     $email_message .= '<tr style="background: #000000; color:#fff"><td colspan="2" align="center"><h3>' . strip_tags($subject) .'</h3></td></tr>';

     // $email_message .= '<thead><tr><th>title</td><td>price</td><td>number</td></tr></thead>';
    foreach ($helpDeskSupportList as $key) {
      if(isset($_POST[$key]) && $_POST[$key] != ''){

        // Adds alternate colors to the table rows
        $colour = ($c++ % 2 == 0) ? '#ffffff' : '#f3f3f3';
        // $colorOne = '#ffffff';
        // $colorTwo = '#f3f3f3';
        // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
        // $rowCount++;

        // email Body
        $email_message .= '<tr bgcolor="' . $colour . '">';
        $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
        $email_message .= '<td>'. wordwrap(htmlspecialchars($_POST[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
        $email_message .= '</tr>';
        // $c++;
      }
  }
       // $email_message .= '</table>';
       $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";
       $email_message .= "</table>";
       $email_message .= "</body></html>";



                // Header for sender info
                $headers = "From: $fromName"." <".$from.">";


                if(!empty($uploadedFile) && file_exists($uploadedFile)){

                    // Boundary
                    $semi_rand = md5(time());
                    $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                    // Headers for attachment
                    $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

                    // Multipart boundary
                    $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
                    "Content-Transfer-Encoding: 7bit\n\n" . $email_message . "\n\n";

                    // Preparing attachment
                    if(is_file($uploadedFile)){
                        $message .= "--{$mime_boundary}\n";
                        $fp =    @fopen($uploadedFile,"rb");
                        $data =  @fread($fp,filesize($uploadedFile));
                        @fclose($fp);
                        $data = chunk_split(base64_encode($data));
                        $message .= "Content-Type: application/octet-stream; name=\"".basename($uploadedFile)."\"\n" .
                        "Content-Description: ".basename($uploadedFile)."\n" .
                        "Content-Disposition: attachment;\n" . " filename=\"".basename($uploadedFile)."\"; size=".filesize($uploadedFile).";\n" .
                        "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                    }

                    $message .= "--{$mime_boundary}--";
                    $returnpath = "-f" . $email;

                    // Send email
                    $mail = mail($toEmail, $subject, $message, $headers, $returnpath);

                    // Delete attachment file from the server
                    @unlink($uploadedFile);
                }else{
                     // Set content-type header for sending HTML email
                    $headers .= "\r\n". "MIME-Version: 1.0";
                    $headers .= "\r\n". "Content-type:text/html;charset=UTF-8";
                    $headers .= "\r\n". "Cc: " . $from .  "\r\n"; #Your BCC Mail List
                    // $headers .= "\r\n"."From: saquib.patwa@strhouston.com" . "\r\n" ."CC: saquib.patwa@strhouston.com";
                    // $headers .= "\r\n". "Cc: saquib.test@strcorpus.com"; #Your BCC Mail List

                    // Send email
                    $mail = mail($toEmail, $subject, $email_message, $headers);
                }

                // If mail sent
                if($mail){

                    // header("location: success.php");
                    echo '<script type="text/javascript"> location.replace("../success.php","_self");</script>';
                    // echo "<script> success(); </script>";
                    // echo '<div style="text-align:center"></div>';
                    // $gourl='http://webdev/wordpress/ITHelpDesk/';
                    // echo '<META HTTP-EQUIV="Refresh" Content="5; URL='.$gourl.'">';
                    // exit;
                    // $statusMsg = 'Your request has been submitted successfully. We will be in touch with you soon. Thank You!';
                    // $msgClass = 'succdiv';

                    $postData = '';
                }else{
                    $statusMsg = 'Your request submission failed, please try again.';
                }
            }
        }
    }else{
        $statusMsg = 'Please fill all the required fields.';
    }
}

//----------------------------------------------------------------------------END OF HELPDESK---------------------------------------------------------------------------------





//----------------------------------------------------------------------------PERSONNEL ACTION NOTICE---------------------------------------------------------------------------------


// session_start();
 $postData1 = $uploadedFile = $statusMsg = '';
 $msgClass = 'errordiv';

 // if ((isset($_POST['submit2'])) && (isset($_POST['submit3']))) {
if(isset($_POST['submit2'])){
     // Get the submitted form data
     $postData1 = $_POST;

     $first_name = mysqli_real_escape_string($conn,$_POST['first_name']);
     $last_name = mysqli_real_escape_string($conn,$_POST['last_name']);
     $nickname = mysqli_real_escape_string($conn,$_POST['nickname']);
     // $effective_date = DATE($_POST['effective_date'], '%y-%m-%d');
     $effective_date = mysqli_real_escape_string($conn,$_POST['effective_date']);
     // $effective_date = date("Y-m-d", strtotime($_POST['effective_date']));
     $branch = mysqli_real_escape_string($conn,$_POST['branch']);
     $department = mysqli_real_escape_string($conn,$_POST['department']);
     $employeeID = mysqli_real_escape_string($conn,$_POST['employeeID']);
     $address= mysqli_real_escape_string($conn,$_POST['address']);
     $city = mysqli_real_escape_string($conn,$_POST['city']);
     $state = mysqli_real_escape_string($conn,$_POST['state']);
     $zip = mysqli_real_escape_string($conn,$_POST['zip']);
     $telephone = mysqli_real_escape_string($conn,$_POST['telephone']);
     $from_email = mysqli_real_escape_string($conn,$_SESSION['from_email']);
     // $ssn = mysqli_real_escape_string($conn,$_POST['ssn']);
     // $attachment = mysqli_real_escape_string($conn,$_POST['fileName']);
     // $section= mysqli_real_escape_string($conn,$_POST['personnelOnly']);
     // $_SESSION['Department'] = htmlentities($_POST['email']);
     $personnelOnly=mysqli_real_escape_string($conn,$_POST['personnelOnly']);
     // Session Variables
     $fileName = mysqli_real_escape_string($conn,$_POST['Attachment']);

     // New Hire Section
     $Hire_Reason = mysqli_real_escape_string($conn,$_POST['Hire_Reason']);
     $replacement_for = mysqli_real_escape_string($conn,$_POST['replacement_for']);
     $employment_Status = mysqli_real_escape_string($conn,$_POST['employment_Status']);
     $drivers_License = mysqli_real_escape_string($conn,$_POST['drivers_License']);
     $state_Issued = mysqli_real_escape_string($conn,$_POST['state_Issued']);
     $date_of_Birth = mysqli_real_escape_string($conn,$_POST['date_of_Birth']);
     $gender = mysqli_real_escape_string($conn,$_POST['gender']);
     $ethnic_Code = mysqli_real_escape_string($conn,$_POST['ethnic_Code']);
     $marital_Status = mysqli_real_escape_string($conn,$_POST['marital_Status']);

     // $job_Title = $_SESSION['job_Title'];
     $job_Title = mysqli_real_escape_string($conn,$_POST['job_Title']);

     $starting_Rate = mysqli_real_escape_string($conn,$_POST['starting_Rate']);
     $per = mysqli_real_escape_string($conn,$_POST['per']);
     $bonus_Commission_Plan = mysqli_real_escape_string($conn,$_POST['bonus_Commission_Plan']);
     $bonus_Level = mysqli_real_escape_string($conn,$_POST['bonus_Level']);

     $Training_Needed = mysqli_real_escape_string($conn,$_POST['Training_Needed']);

     $Technician_Shift = $_SESSION['Technician_Shift'];
     $Technician_Shift = mysqli_real_escape_string($conn,$_POST['Technician_Shift']);

     $Hierarchy_Name = $_SESSION['Hierarchy_Name'];
     $Hierarchy_Name = mysqli_real_escape_string($conn,$_POST['Hierarchy_Name']);

     $Alarm_Code = mysqli_real_escape_string($conn,$_POST['Alarm_Code']);
     $Need_Workstation = mysqli_real_escape_string($conn,$_POST['Need_Workstation']);

     // $other = mysqli_real_escape_string($conn,$_POST['other']);
     $New_Hire_Remarks = mysqli_real_escape_string($conn,$_POST['New_Hire_Remarks']);

    // CHANGE
    // $Job_Title_From = $_SESSION['job_Title'];
    $Job_Title_From = mysqli_real_escape_string($conn,$_POST['Job_Title_From']);

    // $Job_Title_To = $_SESSION['job_Title'];
    $Job_Title_To = mysqli_real_escape_string($conn,$_POST['Job_Title_To']);

  	$Hierarchy_Name_From = mysqli_real_escape_string($conn,$_POST['Hierarchy_Name_From']);
  	$Hierarchy_Name_To = mysqli_real_escape_string($conn,$_POST['Hierarchy_Name_To']);

    $Pay_From = mysqli_real_escape_string($conn,$_POST['Pay_From']);
    $Pay_From_Per = mysqli_real_escape_string($conn,$_POST['Pay_From_Per']);
    $Pay_To = mysqli_real_escape_string($conn,$_POST['Pay_To']);
    $Pay_To_Per = mysqli_real_escape_string($conn,$_POST['Pay_To_Per']);
    $From_Branch = mysqli_real_escape_string($conn,$_POST['From_Branch']);
    $To_Branch = mysqli_real_escape_string($conn,$_POST['To_Branch']);
    $From_Department = mysqli_real_escape_string($conn,$_POST['From_Department']);
    $To_Department = mysqli_real_escape_string($conn,$_POST['To_Department']);
    $From_Employee_Status = mysqli_real_escape_string($conn,$_POST['From_Employee_Status']);
    $To_Employee_Status = mysqli_real_escape_string($conn,$_POST['To_Employee_Status']);
    $Change_Remarks = mysqli_real_escape_string($conn,$_POST['Change_Remarks']);

    // SEPARATION
    $Hire_Date = mysqli_real_escape_string($conn,$_POST['Hire_Date']);
    $Last_Day_Worked = mysqli_real_escape_string($conn,$_POST['Last_Day_Worked']);
    $Separation_Date = mysqli_real_escape_string($conn,$_POST['Separation_Date']);
    $Separation_Type = mysqli_real_escape_string($conn,$_POST['Separation_Type']);
    $Separation_Reason = mysqli_real_escape_string($conn,$_POST['Separation_Reason']);
    $Eligible_to_Rehire = mysqli_real_escape_string($conn,$_POST['Eligible_to_Rehire']);
    $forward_emails = mysqli_real_escape_string($conn,$_POST['forward_emails']);
    $forwarding_to_employee_name = mysqli_real_escape_string($conn,$_POST['forwarding_to_employee_name']);
    $Separation_Remarks = mysqli_real_escape_string($conn,$_POST['Separation_Remarks']);


    //THE ENCRYPTION PROCESS
    // Encrypting the following fields
    // drivers_License
    // date_of_Birth
    // starting_Rate
    // Pay_From
    // Pay_To
    // ssn

    if(!empty($drivers_License)){
        $drivers_License=encryptthis($drivers_License, $secretkey);
    }

    if(!empty($date_of_Birth)){
      $date_of_Birth=encryptthis($date_of_Birth, $secretkey);
    }

    if(!empty($starting_Rate)){
      $starting_Rate=encryptthis($starting_Rate, $secretkey);
    }

    if(!empty($Pay_From)){
      $Pay_From=encryptthis($Pay_From, $secretkey);
    }

    if(!empty($Pay_To)){
      $Pay_To=encryptthis($Pay_To, $secretkey);
    }

    if(!empty($ssn)){
      $ssn=encryptthis($ssn, $secretkey);
    }


    //THE DECRYPTION PROCESS
    // $drivers_License=decryptthis($drivers_License, $secretkey);
    // $date_of_Birth=decryptthis($date_of_Birth, $secretkey);
    // $starting_Rate=decryptthis($starting_Rate, $secretkey);
    // $Pay_From=decryptthis($Pay_From, $secretkey);
    // $Pay_To=decryptthis($Pay_To, $secretkey);
    // $ssn=decryptthis($ssn, $secretkey);

    // // $decryptedSSN = decryptthis($row['ssn'], $key);
    // $ssn = "XXX-XX-". substr($ssn, -4);


    // $rowCount ='';


    // Check whether submitted data is not empty
    if(!empty($from_email)){

        // Validate email
         if(filter_var($from_email, FILTER_VALIDATE_EMAIL) === false){
            $statusMsg = 'Please enter your valid email.';
        }else{
            $uploadStatus = 1;

            // Upload attachment file
            if(!empty($_FILES["attachment"]["name"])){

                // File path config
                $targetDir = "/home/selectran/public_html/helpdesk.selectransportation.com/uploads/";
                // $targetDir = "https://selectransportation.com/helpdesk/uploads/";
                $fileName = basename($_FILES["attachment"]["name"]);
                $targetFilePath = $targetDir . $fileName;
                $fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);

                // Allow certain file formats
               $allowTypes = array('pdf', 'doc', 'docx', 'jpg', 'png', 'jpeg', 'xls', 'xlsx', 'txt');
                if(in_array($fileType, $allowTypes)){
                    // Upload file to the server
                    if(move_uploaded_file($_FILES["attachment"]["tmp_name"], $targetFilePath)){
                      // This commented out displays on web and uncomment to attach to email
                        $uploadedFile = $targetFilePath;
                        // Insert image file name into database
                        // $insert = $conn->query("INSERT INTO PAN_newhire (Attachment) VALUES ('".$fileName."') WHERE newhire_ID = newhire_ID");
                    }else{
                        $uploadStatus = 0;
                        $statusMsg = "Sorry, there was an error uploading your file.";
                    }
                }else{
                    $uploadStatus = 0;
                    $statusMsg = 'Sorry, only PDF, DOC, JPG, JPEG, & PNG files are allowed to upload.';
                }
            }




             if($uploadStatus == 1){

                 $toEmail="";


                  // $subject = $EmailSubject - This is the Email subject
                  $EmailSubject = "PERSONNEL ACTION NOTICE - " . strtoupper($first_name) . " " . strtoupper($last_name);


                  // This is the Table headline Subject
                  $PNsubject = "PERSONNEL ACTION NOTICE";


                  //Form Type
                  if(isset($_POST['personnelOnly'])){

                    if(!empty($_POST['personnelOnly'])) {

                      $personnelOnly=$_POST['personnelOnly'];
                      // echo $personnelOnly;
                    }
                  }


                  // ---------- PATCH: if CHANGE and NO PAY, email Manager + HR (To) and CC submitter ----------
                  // Include the department email configuration
                  $departmentEmails = include 'config.php';

                  // Default email if no match found
                  $toEmail = $departmentEmails['default']; // Fallback to default email

                  // Check if the department email is set for the specific branch and department
                  if (isset($departmentEmails[$branch][$department]) && !empty($departmentEmails[$branch][$department])) {
                      // Use the branch-specific department email if it is set and not empty
                      $toEmail = $departmentEmails[$branch][$department];
                      $subject = $EmailSubject;
                  }

                  echo 'Email to be sent to: ' . $toEmail;

                  // Extract recipient's name from the email
                  $ApprovedBy = explode('@', $toEmail)[0];
                  $ApprovedBy = ucwords(str_replace('.', ' ', $ApprovedBy)); // Changes "admin.branch1" to "Admin Branch1"

                  echo $ApprovedBy;

                  // Set the default subject, this could be customized
                  $subject = $EmailSubject ?? 'Default Subject';
                  echo 'Subject: ' . $subject;

                  // HR address from config (fall back to default if missing)
                  $hrEmail = isset($departmentEmails['HR']) ? trim($departmentEmails['HR']) : (isset($departmentEmails['default']) ? trim($departmentEmails['default']) : '');

                  // Determine manager email (was already in $toEmail earlier) but re-resolve safely:
                  $managerEmail = $toEmail; // $toEmail was set earlier using the branch/department mapping

                  // Determine if it's CHANGE form and Pay NOT selected (checkbox name PayCheckbox)
                  $isChangeForm = (strtoupper(trim($personnelOnly)) === 'CHANGE');
                  $paySelected = isset($_POST['PayCheckbox']); // checkbox is present only when checked

                  $ccForManagerSend = ''; // will hold submitter to CC on manager/HR send (if needed)
                  $managerRecipients = $managerEmail; // default

                  if ($isChangeForm && !$paySelected) {
                      // Send To: Manager + HR
                      $recipientsArr = array_filter([$managerEmail, $hrEmail]);
                      $managerRecipients = implode(', ', $recipientsArr);

                      $ApprovedBy = $ApprovedBy . " + HR";

                      // // CC the submitter (so they also see the approval email)
                      $ccForManagerSend = $from; // $from is the submitter address
                  } else {
                      // Normal behavior: manager only (optionally you can CC someone if needed)
                      $managerRecipients = $managerEmail;
                      $ccForManagerSend = '';
                  }


                  // error_log("Branch: $branch, Department: $department");
                  // if (isset($departmentEmails[$branch][$department])) {
                  //     error_log("Found email for $branch - $department: " . $departmentEmails[$branch][$department]);
                  // } else {
                  //     error_log("No email found for $branch - $department, falling back to default.");
                  // }


                  // echo $ApprovedBy;


                  $Training_Needed = $_POST['Training_Needed']; // Array of selected options

                  // Convert array to comma-separated string
                  $Training_Needed = implode(", ", $Training_Needed);


                 //From Name
                 $nameofManager = $_SESSION['user'];
                 $fromName = $nameofManager;


                  // NEWHIRE QUERY INSERT
                  $query= "INSERT INTO
                    PAN_newhires (
                      first_name,
                      last_name,
                      nickname,
                      effective_date,
                      branch,
                      department,
                      address,
                      city,
                      state,
                      zip,
                      telephone,
                      -- ssn,
                      Hire_Reason,
                      replacement_for,
                      employment_Status,
                      drivers_License,
                      state_Issued,
                      date_of_Birth,
                      gender,
                      ethnic_Code,
                      marital_Status,
                      job_Title,
                      starting_Rate,
                      per,
                      bonus_Commission_Plan,
                      bonus_Level,
                      Training_Needed,
                      Technician_Shift,
                      Hierarchy_Name,
                      Alarm_Code,
                      Need_Workstation,
                      -- other,
                      New_Hire_Remarks,
                      employeeID,
                      Job_Title_From,
                      Job_Title_To,
                      Pay_From,
                      Pay_From_Per,
                      Pay_To,
                      Pay_To_Per,
                      From_Branch,
                      To_Branch,
                      From_Department,
                      To_Department,
                      From_Employee_Status,
                      To_Employee_Status,
                      Hierarchy_Name_From,
                      Hierarchy_Name_To,
                      Change_Remarks,
                      Hire_Date,
                      Last_Day_Worked,
                      Separation_Date,
                      Separation_Type,
                      Separation_Reason,
                      Eligible_to_Rehire,
                      forward_emails,
                      forwarding_to_employee_name,
                      Separation_Remarks,
                      Attachment,
                      Approval_Status,
                      FormType,
                      from_email,
                      fromName,
                      ApprovedOn,
                      ApprovedBy
                    )
                  VALUES(
                      '$first_name',
                      '$last_name',
                      '$nickname',
                      '$effective_date',
                      '$branch',
                      '$department',
                      '$address',
                      '$city',
                      '$state',
                      '$zip',
                      '$telephone',
                      -- '$ssn',
                      '$Hire_Reason',
                      '$replacement_for',
                      '$employment_Status',
                      '$drivers_License',
                      '$state_Issued',
                      '$date_of_Birth',
                      '$gender',
                      '$ethnic_Code',
                      '$marital_Status',
                      '$job_Title',
                      '$starting_Rate',
                      '$per',
                      '$bonus_Commission_Plan',
                      '$bonus_Level',
                      '$Training_Needed',
                      '$Technician_Shift',
                      '$Hierarchy_Name',
                      '$Alarm_Code',
                      '$Need_Workstation',
                      -- '$other',
                      '$New_Hire_Remarks',
                      '$employeeID',
                      '$Job_Title_From',
                      '$Job_Title_To',
                      '$Pay_From',
                      '$Pay_From_Per',
                      '$Pay_To',
                      '$Pay_To_Per',
                      '$From_Branch',
                      '$To_Branch',
                      '$From_Department',
                      '$To_Department',
                      '$From_Employee_Status',
                      '$To_Employee_Status',
                      '$Hierarchy_Name_From',
                      '$Hierarchy_Name_To',
                      '$Change_Remarks',
                      '$Hire_Date',
                      '$Last_Day_Worked',
                      '$Separation_Date',
                      '$Separation_Type',
                      '$Separation_Reason',
                      '$Eligible_to_Rehire',
                      '$forward_emails',
                      '$forwarding_to_employee_name',
                      '$Separation_Remarks',
                      '$fileName',
                      'PENDING FOR APPROVAL',
                      '$personnelOnly',
                      '$from_email',
                      '$fromName',
                      '$ApprovedOn',
                      '$ApprovedBy'
                    )";

                    // mysql_select_db('PAN');
                    $db_select = mysqli_select_db($conn, DB_NAME);


                    if ($conn->query($query) === TRUE) {
                      // echo "New record created for NEWHIRE successfully";
                    } else {
                      echo "Error: " . $query . "<br>" . $conn->error;
                    }

                    //Get the auto-increment id value
                    $id = mysqli_insert_id($conn);
                    $PAN_ID = $id;
                    // echo $PAN_ID;

                    // echo $id;


                 // From Name from Phoenix
                 // $fromName = $_SESSION['user'];


                 // print_r ($fromName);

                 // From Email from Phoenix
                 $from = $from_email; //submitter


     $error_message = "";
     $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';

     //color variable defined for the alternative colors
     $c=1;


     $result=mysqli_query($conn," SELECT * FROM PAN_newhires");




   if($result->num_rows>=1) {

      while($row=$result->fetch_assoc()) {

      // $decryptedSSN = decryptthis($row['ssn'], $secretkey);
      // $decryptedSSN = "XXX-XX-". substr($decryptedSSN, -4);

     // 4 Array lists of input field name
     // General Contact Info Array
     // $personnelNoticeList = array('first_name', 'last_name', 'effective_date', 'branch', 'department', 'employeeID', 'address', 'city', 'state', 'zip', 'telephone', 'ssn');

     // New Hire Section Array
     // $newhireList= array('Hire_Reason', 'replacement_for', 'employment_Status', 'drivers_License', 'state_Issued', 'date_of_Birth', 'gender', 'ethnic_Code', 'marital_Status', 'job_Title', 'starting_Rate', 'per', 'bonus_Commission_Plan', 'bonus_Level', 'other', 'New_Hire_Remarks');

     // Change Section Array
     // $changeList= array('Job_Title_From', 'Job_Title_To', 'Pay_From', 'Pay_From_Per', 'Pay_To', 'Pay_To_Per', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');

     // Separation Section Array
     // $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');



     $personnelNoticeList = array(
         'PAN_ID'           => $id,
         'first_name'       => $row['first_name'],
         'last_name'        => $row['last_name'],
         'nickname'         => $row['nickname'],
         'effective_date'   => $row['effective_date'],
         'branch'           => $row['branch'],
         'department'       => $row['department'],
         'employeeID'       => $row['employeeID'],
         'address'          => $row['address'],
         'city'             => $row['city'],
         'state'            => $row['state'],
         'zip'              => $row['zip'],
         'telephone'        => $row['telephone']
         // 'ssn'              => $decryptedSSN
    );



     // New Hire Section Array
     $newhireList= array(
         'Hire_Reason'               => $row['Hire_Reason'],
         'replacement_for'           => $row['replacement_for'],
         'employment_Status'         => $row['employment_Status'],
         'drivers_License'           => decryptthis($row['drivers_License'], $secretkey),
         'state_Issued'              => $row['state_Issued'],
         'date_of_Birth'             => decryptthis($row['date_of_Birth'], $secretkey),
         'gender'                    => $row['gender'],
         'ethnic_Code'               => $row['ethnic_Code'],
         'marital_Status'            => $row['marital_Status'],
         'job_Title'                 => $row['job_Title'],
         'starting_Rate'             => decryptthis($row['starting_Rate'], $secretkey),
         'per'                       => $row['per'],
         'bonus_Commission_Plan'     => $row['bonus_Commission_Plan'],
         'bonus_Level'               => $row['bonus_Level'],
         'Training_Needed'           => $row['Training_Needed'],
         'Technician_Shift'          => $row['Technician_Shift'],
         'Hierarchy_Name'            => $row['Hierarchy_Name'],
         'Alarm_Code'                => $row['Alarm_Code'],
         'Need_Workstation'          => $row['Need_Workstation'],
         // 'other'                     => $row['other'],
         'New_Hire_Remarks'          => $row['New_Hire_Remarks']
     );

     // Change Section Array
     // $changeList= array('Job_Title_From', 'Job_Title_To', 'Pay_From', 'Pay_From_Per', 'Pay_To', 'Pay_To_Per', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');
     $changeList= array(
         'Job_Title_From'            => $row['Job_Title_From'],
         'Job_Title_To'              => $row['Job_Title_To'],
         'Pay_From'                  => decryptthis($row['Pay_From'], $secretkey),
         'Pay_From_Per'              => $row['Pay_From_Per'],
         'Pay_To'                    => decryptthis($row['Pay_To'], $secretkey),
         'Pay_To_Per'                => $row['Pay_To_Per'],
         'From_Branch'               => $row['From_Branch'],
         'To_Branch'                 => $row['To_Branch'],
         'From_Department'           => $row['From_Department'],
         'To_Department'             => $row['To_Department'],
         'From_Employee_Status'      => $row['From_Employee_Status'],
         'To_Employee_Status'        => $row['To_Employee_Status'],
         'Hierarchy_Name_From'       => $row['Hierarchy_Name_From'],
         'Hierarchy_Name_To'         => $row['Hierarchy_Name_To'],
         'Change_Remarks'            => $row['Change_Remarks']
   );


     // Separation Section Array
     // $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');
     $separationList=array(
         'Hire_Date'                     => $row['Hire_Date'],
         'Last_Day_Worked'               => $row['Last_Day_Worked'],
         'Separation_Date'               => $row['Separation_Date'],
         'Separation_Type'               => $row['Separation_Type'],
         'Separation_Reason'             => $row['Separation_Reason'],
         'Eligible_to_Rehire'            => $row['Eligible_to_Rehire'],
         'forward_emails'                => $row['forward_emails'],
         'forwarding_to_employee_name'   => $row['forwarding_to_employee_name'],
         'Separation_Remarks'            => $row['Separation_Remarks'],
   );



      $email_message =  '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px; border-radius:7px 7px 0 0" cellpadding="10">';
      $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="https://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
      $email_message .= '<tr style="background: #000000; color:#fff; border-radius: 8px 8px 0 0"><td colspan="2" align="center"><h3>' . strip_tags($PNsubject) .'</h3></td></tr>';



      // GENERAL INFO SECTION
     foreach ($personnelNoticeList as $key => $personnelNoticeListValues) {
         if(isset($row[$key]) && $row[$key] != ''){

           // Adds alternate colors to the table rows
           $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
           // $colorOne = '#ffffff';
           // $colorTwo = '#f3f3f3';
           // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
           // $rowCount++;

           // email Body
           $email_message .= '<tr bgcolor="' . $colour . '">';
           // $email_message .= '<td><strong>'. strtoupper(ucwords(str_replace("_", " ",$key)))  . '</strong></td>';
           $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
           $email_message .= '<td>'. wordwrap(htmlspecialchars($personnelNoticeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
           $email_message .= '</tr>';
           $c++;
         }
      }

    $email_message .= '<tr style="background: #000000; color:#fff;"><td colspan="2" align="center" id="NewHireEmailTitle"><h3>'. $row['FormType'] . '</h3></td></tr>';
    foreach ($newhireList as $key => $newhireListValues) {
            if(isset($row[$key]) && $row[$key] != ''){

            // Adds alternate colors to the table rows
            $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
            // $colorOne = '#ffffff';
            // $colorTwo = '#f3f3f3';
            // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
            // $rowCount++;

            // email Body
            $email_message .= '<tr bgcolor="' . $colour . '">';
            $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
            $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($newhireListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
            $email_message .= '</tr>';
            $c++;
          }
       }

   // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="ChangeEmailTitle"><h3>'. $ChangeEmailTitle . '</h3></td></tr>';
   foreach ($changeList as $key => $changeListValues) {
               if(isset($row[$key]) && $row[$key] != ''){

               // Adds alternate colors to the table rows
               $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
               // $colorOne = '#ffffff';
               // $colorTwo = '#f3f3f3';
               // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
               // $rowCount++;

               // email Body
               $email_message .= '<tr bgcolor="' . $colour . '">';
               $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
               $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($changeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
               $email_message .= '</tr>';
               $c++;
          }
      }

  // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="SeparationEmailTitle"><h3>'. $SeparationEmailTitle . '</h3></td></tr>';
  foreach ($separationList as $key => $separationListValues) {
          if(isset($row[$key]) && $row[$key] != ''){

              // Adds alternate colors to the table rows
              $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
              // $colorOne = '#ffffff';
              // $colorTwo = '#f3f3f3';
              // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
              // $rowCount++;

              // email Body
              $email_message .= '<tr bgcolor="' . $colour . '">';
              $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
              $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($separationListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
              $email_message .= '</tr>';
              $c++;
          }
      }
        // $email_message .= '</table>';
        // $salt="STRICTLY_PERSONNEL_ONLY";
        // $email_message .= '<tr bgcolor="#ccc">';
        // $email_message .= '<td colspan="2" width="100%" height="30" bgcolor="#1F7F4C" style="text-align:center; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; color: #ffffff; display: block;">
        // <a href="https://helpdesk.selectransportation.com/approval.php?PAN_ID=' . base64_encode($id) .  '&personnelOnly=' . base64_encode($personnelOnly) .'" style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">APPROVE/REJECT</span></a>
        // </td>';
        // $email_message .= '</tr>';

        $email_message .= '<tr>';
        $email_message .= '<td colspan="2" width="100%" height="40" style="text-align:center; background-color:#1F7F4C; border-radius:5px; color: #ffffff; text-decoration: none;">';
        $email_message .= '<a href="https://helpdesk.selectransportation.com/approval.php?PAN_ID=' . base64_encode($id) .  '&personnelOnly=' . base64_encode($personnelOnly) . '"
            style="
                background-color: #1F7F4C;
                color: #ffffff;
                padding: 10px 30px;
                text-decoration: none;
                font-weight: bold;
                font-family: Helvetica, Arial, sans-serif;
                font-size: 15px;
                border-radius: 5px;
                display: inline-block;
                min-width: 200px;
                text-align: center;
                text-decoration: none !important;
            ">
            APPROVE | REJECT
        </a>';
        $email_message .= '</td>';
        $email_message .= '</tr>';

        $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";
        $email_message .= "</table>";
        $email_message .= "</body></html>";


      }
    }



                 // Header for sender info
                 $headers = "From: $fromName"." <".$from.">";

                 if(!empty($uploadedFile) && file_exists($uploadedFile)){

                     // Boundary
                     $semi_rand = md5(time());
                     $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                     // Headers for attachment
                     $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

                     // Multipart boundary
                     $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
                     "Content-Transfer-Encoding: 7bit\n\n" . $email_message . "\n\n";

                     // Preparing attachment
                     if(is_file($uploadedFile)){
                         $message .= "--{$mime_boundary}\n";
                         $fp =    @fopen($uploadedFile,"rb");
                         $data =  @fread($fp,filesize($uploadedFile));
                         @fclose($fp);
                         $data = chunk_split(base64_encode($data));
                         $message .= "Content-Type: application/octet-stream; name=\"".basename($uploadedFile)."\"\n" .
                         "Content-Description: ".basename($uploadedFile)."\n" .
                         "Content-Disposition: attachment;\n" . " filename=\"".basename($uploadedFile)."\"; size=".filesize($uploadedFile).";\n" .
                         "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                     }

                     $message .= "--{$mime_boundary}--";
                     $returnpath = "-f" . $from;

                     // Send email
                     $mail = mail($managerRecipients, $subject, $message, $headers, $returnpath);

                     // Delete attachment file from the server
                     // @unlink($uploadedFile);
                 }else{
                      // Set content-type header for sending HTML email
                     $headers .= "\r\n". "MIME-Version: 1.0";
                     $headers .= "\r\n". "Content-type:text/html;charset=UTF-8";
                     // $headers .= "\r\n". "Cc: " . $from .  "\r\n"; #Your BCC Mail List
                     // $headers .= "\r\n"."From: saquib.patwa@strhouston.com" . "\r\n" ."CC: saquib.patwa@strhouston.com";
                     // $headers .= "\r\n". "cc: saquib.test@houstonfreightliner.com"; #Your BCC Mail List

                      // $headers .= "\r\n". "Bcc: saquib.test@strhouston.com"; #Your BCC Mail List

                      // $headers.="Bcc: ".implode(", ",$from_email)."\r\n";  // blind carbon copy all emails
                      // $headers .= "Cc: " . implode(", ", ['$from', $from_email]) .  "\r\n"; #Your BCC Mail List

                     // Send email
                     $mail = mail($managerRecipients, $subject, $email_message, $headers);
                 }

                 // If mail sent
                 if($mail){

                     // header("location: success.php");
                     echo '<script type="text/javascript"> location.replace("../success.php","_self");</script>';

                     // echo $drivers_License;
                     // echo "<br />";
                     // echo  $ssn;
                     // echo $personnelOnly;

                     $postData1 = '';
                 }else{
                     $statusMsg = '<br />Your request submission failed, please try again.';
                 }
 //             }
 //         }
 //     }else{
 //         $statusMsg = 'Please fill all the required fields.';
 //
 //     }
 // }


 // --- END OF EMAIL TO VP ---


  //  --- EMAIL TO THE SUBMITTER OF PAN ---

  $toEmail = $from;

  $result1=mysqli_query($conn," SELECT * FROM PAN_newhires");

  if($result1->num_rows>=1) {

   while($row=$result1->fetch_assoc()) {

     // SSN
     $decryptedSSN = decryptthis($row['ssn'], $secretkey);
     $decryptedSSN = "XXX-XX-". substr($decryptedSSN, -4);




  $personnelNoticeList = array(
      'PAN_ID'           => $id,
      'first_name'       => $row['first_name'],
      'last_name'        => $row['last_name'],
      'nickname'         => $row['nickname'],
      'effective_date'   => $row['effective_date'],
      'branch'           => $row['branch'],
      'department'       => $row['department'],
      'employeeID'       => $row['employeeID'],
      'address'          => $row['address'],
      'city'             => $row['city'],
      'state'            => $row['state'],
      'zip'              => $row['zip'],
      'telephone'        => $row['telephone']
      // 'ssn'              => $decryptedSSN
  );



  // New Hire Section Array
  $newhireList= array(
      'Hire_Reason'               => $row['Hire_Reason'],
      'replacement_for'           => $row['replacement_for'],
      'employment_Status'         => $row['employment_Status'],
      // 'drivers_License'           => decryptthis($row['drivers_License'], $secretkey),
      'state_Issued'              => $row['state_Issued'],
      'date_of_Birth'             => decryptthis($row['date_of_Birth'], $secretkey),
      'gender'                    => $row['gender'],
      'ethnic_Code'               => $row['ethnic_Code'],
      'marital_Status'            => $row['marital_Status'],
      'job_Title'                 => $row['job_Title'],
      'starting_Rate'             => decryptthis($row['starting_Rate'], $secretkey),
      'per'                       => $row['per'],
      'bonus_Commission_Plan'     => $row['bonus_Commission_Plan'],
      'bonus_Level'               => $row['bonus_Level'],
      'Training_Needed'           => $row['Training_Needed'],
      'Technician_Shift'          => $row['Technician_Shift'],
      'Hierarchy_Name'            => $row['Hierarchy_Name'],
      'Alarm_Code'                => $row['Alarm_Code'],
      'Need_Workstation'          => $row['Need_Workstation'],
      // 'other'                     => $row['other'],
      'New_Hire_Remarks'          => $row['New_Hire_Remarks']
  );

  // Change Section Array
  // $changeList= array('Job_Title_From', 'Job_Title_To', 'Pay_From', 'Pay_From_Per', 'Pay_To', 'Pay_To_Per', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');
  $changeList= array(
      'Job_Title_From'            => $row['Job_Title_From'],
      'Job_Title_To'              => $row['Job_Title_To'],
      'Pay_From'                  => decryptthis($row['Pay_From'], $secretkey),
      'Pay_From_Per'              => $row['Pay_From_Per'],
      'Pay_To'                    => decryptthis($row['Pay_To'], $secretkey),
      'Pay_To_Per'                => $row['Pay_To_Per'],
      'From_Branch'               => $row['From_Branch'],
      'To_Branch'                 => $row['To_Branch'],
      'From_Department'           => $row['From_Department'],
      'To_Department'             => $row['To_Department'],
      'From_Employee_Status'      => $row['From_Employee_Status'],
      'To_Employee_Status'        => $row['To_Employee_Status'],
      'Hierarchy_Name_From'       => $row['Hierarchy_Name_From'],
      'Hierarchy_Name_To'         => $row['Hierarchy_Name_To'],
      'Change_Remarks'            => $row['Change_Remarks']
  );


  // Separation Section Array
  // $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');
  $separationList=array(
      'Hire_Date'                     => $row['Hire_Date'],
      'Last_Day_Worked'               => $row['Last_Day_Worked'],
      'Separation_Date'               => $row['Separation_Date'],
      'Separation_Type'               => $row['Separation_Type'],
      'Separation_Reason'             => $row['Separation_Reason'],
      'Eligible_to_Rehire'            => $row['Eligible_to_Rehire'],
      'forward_emails'                => $row['forward_emails'],
      'forwarding_to_employee_name'   => $row['forwarding_to_employee_name'],
      'Separation_Remarks'            => $row['Separation_Remarks']
  );



   $email_message =  '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px; border-radius:7px 7px 0 0" cellpadding="10">';
   $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="https://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
   $email_message .= '<tr style="background: #000000; color:#fff; border-radius: 8px 8px 0 0"><td colspan="2" align="center"><h3>' . strip_tags($subject) .'</h3></td></tr>';



   // GENERAL INFO SECTION
  foreach ($personnelNoticeList as $key => $personnelNoticeListValues) {
      if(isset($row[$key]) && $row[$key] != ''){

        // Adds alternate colors to the table rows
        $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
        // $colorOne = '#ffffff';
        // $colorTwo = '#f3f3f3';
        // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
        // $rowCount++;

        // email Body
        $email_message .= '<tr bgcolor="' . $colour . '">';
        // $email_message .= '<td><strong>'. strtoupper(ucwords(str_replace("_", " ",$key)))  . '</strong></td>';
        $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
        $email_message .= '<td>'. wordwrap(htmlspecialchars($personnelNoticeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
        $email_message .= '</tr>';
        $c++;
      }
   }

  $email_message .= '<tr style="background: #000000; color:#fff;"><td colspan="2" align="center" id="NewHireEmailTitle"><h3>'. $row['FormType'] . '</h3></td></tr>';
  foreach ($newhireList as $key => $newhireListValues) {
         if(isset($row[$key]) && $row[$key] != ''){

         // Adds alternate colors to the table rows
         $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
         // $colorOne = '#ffffff';
         // $colorTwo = '#f3f3f3';
         // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
         // $rowCount++;

         // email Body
         $email_message .= '<tr bgcolor="' . $colour . '">';
         $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
         $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($newhireListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
         $email_message .= '</tr>';
         $c++;
       }
    }

  // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="ChangeEmailTitle"><h3>'. $ChangeEmailTitle . '</h3></td></tr>';
  foreach ($changeList as $key => $changeListValues) {
            if(isset($row[$key]) && $row[$key] != ''){

            // Adds alternate colors to the table rows
            $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
            // $colorOne = '#ffffff';
            // $colorTwo = '#f3f3f3';
            // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
            // $rowCount++;

            // email Body
            $email_message .= '<tr bgcolor="' . $colour . '">';
            $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
            $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($changeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
            $email_message .= '</tr>';
            $c++;
       }
   }

  // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="SeparationEmailTitle"><h3>'. $SeparationEmailTitle . '</h3></td></tr>';
  foreach ($separationList as $key => $separationListValues) {
       if(isset($row[$key]) && $row[$key] != ''){

           // Adds alternate colors to the table rows
           $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
           // $colorOne = '#ffffff';
           // $colorTwo = '#f3f3f3';
           // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
           // $rowCount++;

           // email Body
           $email_message .= '<tr bgcolor="' . $colour . '">';
           $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
           $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($separationListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
           $email_message .= '</tr>';
           $c++;
       }
   }
     // $email_message .= '</table>';
     // $salt="STRICTLY_PERSONNEL_ONLY";
     // $email_message .= '<tr bgcolor="#ccc">';
     // $email_message .= '<td colspan="2" width="100%" height="30" bgcolor="#1F7F4C" style="text-align:center; -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; color: #ffffff; display: block;">
     // <a href="http://webdev.str.com/wordpress/helpdesk/approval.php?PAN_ID=' . base64_encode($id) .  '&personnelOnly=' . base64_encode($personnelOnly) .'" style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">APPROVE/REJECT</span></a>
     // </td>';
     // $email_message .= '</tr>';

     $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";
     $email_message .= "</table>";
     $email_message .= "</body></html>";


   }
  }

              // Header for sender info
              $headers = "From: $fromName"." <".$from.">";

              if(!empty($uploadedFile) && file_exists($uploadedFile)){

                  // Boundary
                  $semi_rand = md5(time());
                  $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                  // Headers for attachment
                  $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

                  // Multipart boundary
                  $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
                  "Content-Transfer-Encoding: 7bit\n\n" . $email_message . "\n\n";

                  // Preparing attachment
                  if(is_file($uploadedFile)){
                      $message .= "--{$mime_boundary}\n";
                      $fp =    @fopen($uploadedFile,"rb");
                      $data =  @fread($fp,filesize($uploadedFile));
                      @fclose($fp);
                      $data = chunk_split(base64_encode($data));
                      $message .= "Content-Type: application/octet-stream; name=\"".basename($uploadedFile)."\"\n" .
                      "Content-Description: ".basename($uploadedFile)."\n" .
                      "Content-Disposition: attachment;\n" . " filename=\"".basename($uploadedFile)."\"; size=".filesize($uploadedFile).";\n" .
                      "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                  }

                  $message .= "--{$mime_boundary}--";
                  $returnpath = "-f" . $from;

                  // Send email
                  $mail = mail($toEmail, $subject, $message, $headers, $returnpath);

                  // Delete attachment file from the server
                  // @unlink($uploadedFile);
              } else{
                   // Set content-type header for sending HTML email
                  $headers .= "\r\n". "MIME-Version: 1.0";
                  $headers .= "\r\n". "Content-type:text/html;charset=UTF-8";
                  // $headers .= "\r\n"."From: saquib.patwa@strhouston.com" . "\r\n" ."CC: saquib.patwa@strhouston.com";
                  // $headers .= "\r\n". "cc: saquib.test@houstonfreightliner.com"; #Your BCC Mail List
                   // $headers .= "\r\n". "Cc: " . $from .  "\r\n"; #Your BCC Mail List
                   // $headers .= "\r\n". "Bcc: saquib.test@strhouston.com"; #Your BCC Mail List

                   // $headers.="Bcc: ".implode(", ",$from_email)."\r\n";  // blind carbon copy all emails
                   // $headers .= "Cc: " . implode(", ", ['$from', $from_email]) .  "\r\n"; #Your BCC Mail List

                  // Send email
                  $mail = mail($toEmail, $subject, $email_message, $headers);
              }

              // If mail sent
              if($mail){



                  // header("location: success.php");
                  // echo '<script type="text/javascript"> location.replace("../helpdesk/success.php","_self");</script>';

                  // if(!$result) {
                  //      echo "Error";
                  // } else {
                  //     echo "Success Email Sent";
                  // }

                  // echo $drivers_License;
                  // echo "<br />";
                  // echo  $ssn;
                  // echo $personnelOnly;

                  // $postData1 = '';
              } else {
                  $statusMsg = '<br />Your request submission failed, please try again.';
              }
          } // Validate Email
      } //else upload attachment
  } // Check whether submitted data is not empty

  else {
      $statusMsg = 'Please fill all the required fields.';
  }

} // end of submit2 button


// THIS ELSE PUTS THE HELPDESK PAGE TO UNDERCONTRUCTION PAGE
} else {
    // Show Closed RSVP page content
    header('Location: Undercontruction.php');
    exit();
}

//----------------------------------------------------------------------------END OF PERSONNEL ACTION NOTICE---------------------------------------------------------------------------------

 ?>

 <!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="cache-control" content="no-cache">

           <title>STR Help Desk</title>

           <!--===============================================================================================-->
               <!-- Favicon -->
               <!-- <link rel="icon" type="image/png" href="../helpdesk/Images/icons/help.ico"/> -->
           <!--===============================================================================================-->
               <!-- Bootstrap CSS -->
               <link rel="stylesheet" type="text/css" href="/vendor/bootstrap/css/bootstrap.min.css">
               <link href="/css/bootstrap_v3.2.0.css" rel="stylesheet" type="text/css" />
           <!--===============================================================================================-->
               <!-- Font Awesome -->
               <!-- <link rel="stylesheet" type="text/css" href="/helpdesk/fonts/font-awesome-4.7.0/css/font-awesome.min.css"> -->
               <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">


           <!--===============================================================================================-->
               <!-- Fonts -->
               <link rel="stylesheet" type="text/css" href="/css/util.css">
               <!-- Main CSS -->
               <link rel="stylesheet" type="text/css" href="/css/main.css">
               <!-- forms and Buttons -->
               <link rel="stylesheet" type="text/css" href="/css/misc.css">
           <!--===============================================================================================-->

           <!--===============================================================================================-->
            <!-- This is to create an App Icon when you save to you website to your homescreen.
                 Use the website www.favicon-generator.org/ to create an app icon and the code from the same website -->

                <link rel="apple-touch-icon" sizes="57x57" href="../Images/icons/Icons/apple-icon-57x57.png">
                <link rel="apple-touch-icon" sizes="60x60" href="../Images/icons/Icons/apple-icon-60x60.png">
                <link rel="apple-touch-icon" sizes="72x72" href="../Images/icons/Icons/apple-icon-72x72.png">
                <link rel="apple-touch-icon" sizes="76x76" href="../Images/icons/Icons/apple-icon-76x76.png">
                <link rel="apple-touch-icon" sizes="114x114" href="../Images/icons/Icons/apple-icon-114x114.png">
                <link rel="apple-touch-icon" sizes="120x120" href="../Images/icons/Icons/apple-icon-120x120.png">
                <link rel="apple-touch-icon" sizes="144x144" href="../Images/icons/Icons/apple-icon-144x144.png">
                <link rel="apple-touch-icon" sizes="152x152" href="../Images/icons/Icons/apple-icon-152x152.png">
                <link rel="apple-touch-icon" sizes="180x180" href="../Images/icons/Icons/apple-icon-180x180.png">
                <link rel="icon" type="image/png" sizes="192x192"  href="../Images/icons/Icons/android-icon-192x192.png">
                <link rel="icon" type="image/png" sizes="32x32" href="../Images/icons/Icons/favicon-32x32.png">
                <link rel="icon" type="image/png" sizes="96x96" href="../Images/icons/Icons/favicon-96x96.png">
                <link rel="icon" type="image/png" sizes="16x16" href="../Images/icons/Icons/favicon-16x16.png">
                <link rel="mask-icon" href="../Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
                <link rel="manifest" href="../Images/icons/Icons/manifest.json">
                <meta name="msapplication-TileColor" content="#ffffff">
                <meta name="msapplication-TileImage" content="../Images/icons/Icons/ms-icon-144x144.png">
                <meta name="theme-color" content="#ffffff">

            <!--===============================================================================================-->

               <!-- JQuery -->
               <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
           <!--===============================================================================================-->

              <!-- <script src="//code.jquery.com/jquery.min.js"></script> -->
              <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
              <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> -->


              <!--DATEPICKER ===============================================================================================-->
              <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
              <script src="//code.jquery.com/jquery-1.10.2.js"></script>
              <script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
              <!--===============================================================================================-->


              <!--SSN MASKING===============================================================================================-->
                 <!-- <script type="text/javascript" src="/helpdesk/js/jquery.js"></script> -->
                 <script type="text/javascript" src="/js/jquery.maskedinput.min.js"></script>
                 <script type="text/javascript" src="/js/jquery.maskssn.js"></script>
              <!--===============================================================================================-->


              <script>
                  // Ensure the page is not cached when using the back button
                  (function() {
                      window.history.replaceState(null, null, window.location.href);
                      window.onunload = function() { null };
                  })();
              </script>


      </head>

      <body class="contact1">


        <!-- centering the entire div -->
        <div align="center" style="margin:auto">

        <!-- logo -->
        <div class="contact1 logo"><img src="../Images/STR-Logo-Med2.png" class="logo" /></div> <br>
        <h3>I NEED HELP FROM</h3><br>
        <!-- BUTTONS-->
        <button id="DivIdToScroll" type="button" target="1" class="btn success showSingle" name="btnIT" value="BtnIT" onclick='btnclick("SUBMIT AN IT HELPDESK TICKET","btnIT","DivIdToScroll")'>IT</button>
        <button id="DivIdToScroll1" type="button" target="1" class="btn success showSingle" name="btnPH" value="BtnPH" onclick='btnclick("SUBMIT A PHOENIX HELPDESK TICKET","btnPH","DivIdToScroll1");'>PHOENIX</button>
        <button id="DivIdToScroll2"  type="button"   target="1" class="btn success showSingle" name="btnHR" value="BtnHR" onclick='btnclick("SUBMIT A HR HELPDESK TICKET","btnHR","DivIdToScroll2");'>HR</button>
        <button id="DivIdToScroll3" type="button" class="btn success showSingle" target="2"   data-toggle="modal" data-target="#loginModal"  onclick="HideContainerOne(); ">PERSONNEL<br />ACTION NOTICE</button>
        <button id="DivIdToScroll4"  type="button"   target="1" class="btn success showSingle" name="btnFAC" value="BtnFAC" onclick='btnclick("SUBMIT A FACILITY REQUEST","btnFAC","DivIdToScroll4");'>FACILITY<br />REQUEST</button>
        <button id="DivIdToScroll5" type="button" target="1" class="btn success showSingle" name="btnDashboard" value="BtnDashboard" onclick='btnclick("SUBMIT A DASHBOARD REQUEST","btnDashboard","DivIdToScroll5")'>DASHBOARD <br />REQUEST</button>




<div id="scroll_div">

  <div class="container-contact1" id="container-contact1" >

     <button class="close" onclick="document.getElementById('container-contact1').style.display='none'" id="formclose1">X</button>

     <div  id="div1" class="targetDiv" style="display: none">


             <!--     <form  id="HelpDeskForm" class="contact1-form validate-form1 needs-validation" novalidate  method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" enctype="multipart/form-data" > -->

                  <form id="contact1-form" class="contact1-form validate-form2 needs-validation" novalidate="novalidate" method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" enctype="multipart/form-data" >
                     <span class="contact1-form-title"></span>

                     <div class="row">
                           <div class="wrap-input1 form-group col-6" data-validate = "First Name is required">
                               <input class="form-control input1" type="text" name="First_Name"  value="<?php echo !empty($postData['First_Name'])?$postData['First_Name']:''; ?>" pattern="[a-zA-Z\.\s]+" placeholder="First Name" required>
                               <!-- <span class="shadow-input1"></span> -->
                           </div>

                           <div class="wrap-input1 form-group col-6" data-validate = "Last Name is required">

                               <input class="form-control input1" type="text" name="Last_Name"  value="<?php echo !empty($postData['Last_Name'])?$postData['Last_Name']:''; ?>" pattern="[a-zA-Z\.\s]+" placeholder="Last Name" required>
                               <!-- <span class="shadow-input1"></span> -->
                           </div>
                     </div>


                     <div class="row">
                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Valid email is required: ex@abc.xyz">
                             <input class="form-control input1" type="email" name="email" id="email" value="<?php echo !empty($postData['email'])?$postData['email']:''; ?>"
                             pattern="[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$" placeholder="Email" required>
                             <span class="shadow-input1"></span>
                         </div>

                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Phone Number is required">
                             <input class="form-control input1" type="text" name="phone" value="<?php echo !empty($postData['phone'])?$postData['phone']:''; ?>" placeholder="Phone Number"  onKeyup="formatPhone(this);" maxlength="12" pattern="^\D?(\d{3})\D?\D?(\d{3})\D?(\d{4})$">
                             <span class="shadow-input1"></span>
                         </div>
                     </div>


                     <div class="row">
                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Extension is required">
                             <input class="form-control input1" type="text" name="extension" pattern="(x\[0-9]{4}"  maxlength="6" value="<?php echo !empty($postData['extension'])?$postData['extension']:''; ?>"
                             oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\x..*?)\..*/g, '$1');"  placeholder="Extension" >
                             <span class="shadow-input1"></span>
                         </div>

                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Workstation is required" id="ShowHideWorkstation">
                             <input class="form-control input1" type="text" name="workstation" value="<?php echo !empty($postData['workstation'])?$postData['workstation']:''; ?>" placeholder="Workstation">
                             <span class="shadow-input1"></span>
                         </div>
                     </div>


                     <div class="row">
                         <div class="wrap-input1  col-md-6" >
                               <select id="branch" name="branch"  class="browser-default form-select input1"  required>
                                 <option value="" disabled selected>Branch</option>
                                 <option value="010-HFI-BODYSHOP">010-HFI-BODYSHOP</option>
                                 <option value="010-HFI">010-HFI</option>
                                 <option value="010-HFI-DART">010-HFI-DART</option>
                                 <option value="012-TALKEBTC">012-TALKEBTC</option>
                                 <option value="013-HFI INTERNET SALES">013-HFI INTERNET SALES</option>
                                 <option value="014-BROOKSHIRE">014-BROOKSHIRE</option>
                                 <option value="017-HDTP">017-HDTP</option>
                                 <option value="011-HFW-TODD">011-HFW-TODD</option>
                                 <option value="019-HFN-CONROE">019-HFN-CONROE</option>
                                 <option value="020-CCF">020-CCF</option>
                                 <option value="022-VIC">022-VIC</option>
                                 <option value="030-BMT">030-BMT</option>
                                 <option value="032-LF">032-LF</option>
                                 <option value="041-SELECLEASE">041-SELECLEASE</option>
                                 <option value="060-TBGC">060-TBGC</option>
                                 <option value="080-STR">080-STR</option>
                                 <option value="090-STC">090-STC</option>
                                 <option value="095-STCW">095-STCW</option>

                               </select>
                         </div>

                         <div class="wrap-input1  col-md-6"  >
                               <select  name="department"   class="browser-default form-select input1"   required>
                                 <option value="" disabled selected>Department</option>
                                 <option value="New Truck">New Truck</option>
                                 <option value="Used Truck">Used Truck</option>
                                 <option value="Parts">Parts</option>
                                 <option value="Service">Service</option>
                                 <option value="Body Shop">Body Shop</option>
                                 <option value="Accounting">Accounting</option>
                                 <option value="Administration">Administration</option>
                                 <option value="IT">IT</option>
                                 <option value="SelecSoftware">SelecSoftware</option>
                                 <option value="STR Parts Sales Support & Employee Development">STR Parts Sales Support & Employee Development</option>
                               </select>
                         </div>
                     </div>


                     <div class="row" id="empIDDiv">
                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Employee ID is required">
                             <input class="form-control input1" type="text" name="employeeID" onkeypress="return isNumberKey(event)"  value="<?php echo !empty($postData['employeeID'])?$postData['employeeID']:''; ?>" placeholder="Employee ID">
                             <span class="shadow-input1"></span>
                         </div>
                     </div>

                     <div class="row" id="roomBuildingDiv" style="display:none;">

                         <div class="wrap-input1  col-md-6"  >
                               <select  name="Building"   class="browser-default form-select input1" >
                                 <option value="" disabled selected>Building</option>
                                 <!-- <option style="color:#FAFAFA" value="">Building</option> -->
                                 <option value="Main">MAIN</option>
                                 <option value="Training">TRAINING</option>
                                 <option value="Security">SECURITY</option>

                               </select>
                         </div>

                         <div class="wrap-input1 validate-input1 col-6" data-validate = "Room No is required">
                             <input class="form-control input1" type="text" name="RoomNo"   value="<?php echo !empty($postData['RoomNo'])?$postData['RoomNo']:''; ?>" placeholder="Room Name/No.">
                             <span class="shadow-input1"></span>
                         </div>
                     </div>


                     <div class="wrap-input1 validate-input1" data-validate = "Message is required">

                         <textarea class="form-control input1" name="message" placeholder="Please explain your issue in depth and attach screenshot or document below" required><?php echo !empty($postData['message1'])?$postData['message1']:''; ?></textarea>
                         <span class="shadow-input1"></span>
                     </div>

                      <div class="form-group">
                         <input type="file" name="attachment" class="form-control" multiple="multiple">
                     </div>

                     <!-- Recaptcha -->
                     <!-- <div class="form-group g-recaptcha" data-sitekey="6Lf3cbEUAAAAAPX24QtSlMBtl6De3CELTn4Vr7LG"></div> -->
                     <!-- <?php echo $math; ?> = <input name="answer" type="text" /> -->



                     <div class="container-contact1-form-btn">
                         <!-- <input type="submit" name="submit" class="contact1-form-btn" value="SUBMIT">                  -->

                          <button class="contact1-form-btn" type="submit" id="submit" name="submit">
                             <span>
                                 SUBMIT
                                 <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                             </span>
                         </button>
                     </div>
                     <div>
                         <!-- Display Error status -->
                         <br>
                         <?php if(!empty($statusMsg)){ ?>
                             <p class="statusMsg <?php echo !empty($msgClass)?$msgClass:''; ?>"><?php echo $statusMsg; ?></p>
                         <?php } ?>
                     </div>

                 </form>

      </div> <!-- End of target Div1 -->

</div><!-- End of modal -->







<?php
// session_start();
if(isset($_SESSION['user']))
{

?>


<div id="container-contact2"  class="container-contact2">
  <!-- <button class="close" onclick="document.getElementById('container-contact2').style.display='none'" id="formclose1">X</button> -->

<div class="container">
  <div class="row">
    <div class="col-8" align="center">

       <?php
        date_default_timezone_set('America/Chicago');

        // Get the current hour
        $current_hour = date('G');
        $greeting = "";

        // Greet based on the time of day
        if ($current_hour >=5 && $current_hour < 12) {
          $greeting= "Good Morning";
        }
        elseif ($current_hour >= 12 && $current_hour < 18) {
          $greeting = "Good Afternoon";
        }
        else {
          $greeting = "Good Evening";
        }

        ?>



      <p class="loginName"><?php echo strtoupper($greeting) . ", <br /> " . $_SESSION['user']; ?></p><br />




    </div>
    <div class="col-4" align="right">
      <a href="../logout.php" class="logoutbtn successLogout" name="logout" id="logout">LOGOUT</a>
    </div>
  </div>
</div>


  <div  id="div2" class="targetDiv" align="center">

     <!-- <h6>HOWDY!! - <?php echo $_SESSION['user']; ?> &nbsp;&nbsp; | &nbsp;&nbsp; <a href="logout.php" id="logout">Logout</a></h6> -->

                           <form  id="form2" class="contact2-form needs-validation" novalidate="novalidate" method="post" action="" enctype="multipart/form-data" >

                            <span class="contact2-form-title">PERSONNEL ACTION NOTICE</span><br /><span class="contact2-form-title-confidential"> CONFIDENTIAL</span><br /><br />

                            <div id="EmpOrCust">
                              <h4 align="center">What would you like to do? </h4>

                              <div class="row">
                                <div class="container-fluid" align="center">
                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly" id="newhire" value="NEW HIRE" class="newhire" required>
                                      <label class="form-check-label NewHireCheckboxTitle" for="newhire">NEW HIRE</label>
                                    </div>

                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly"  id="change"   value="CHANGE" class="change" required>
                                      <label class="form-check-label" for="change">CHANGE</label>
                                    </div>

                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly"  id="separation" value="SEPARATION" class="separation" required>
                                      <label class="form-check-label" for="separation">SEPARATION</label>
                                    </div>

                                </div>
                              </div>
                        <br />


                          <!-- General Info -->
                            <div class="row">  <!--Date  pattern="\d{1,2}/\d{1,2}/\d{4}" -->
                                <div class="wrap-input1 validate-input col-md-6  date" data-validate = "Date is required" >
                                  <input class="form-control input1 date-withicon" type="text"  name="effective_date"   placeholder="Effective Date"  value="<?php echo !empty($postData1['effective_date'])?$postData1['effective_date']:''; ?>"    required>
                                  <!-- <span class="input1-group-addon placeholder"></span> -->
                                </div>

                            </div>


                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6" data-validate = "First Name is required">
                                    <input class="form-control input1" type="text" name="first_name"  value="<?php echo !empty($postData1['first_name'])?$postData1['first_name']:''; ?>" placeholder="First Name"   required>
                                    <!-- <span class="shadow-input1 placeholder"></span> -->
                                </div>

                                <div class="wrap-input1 validate-input col-md-6" data-validate = "Last Name is required">
                                    <input class="form-control input1" type="text" name="last_name"  value="<?php echo !empty($postData1['last_name'])?$postData1['last_name']:''; ?>" placeholder="Last Name"   required>
                                    <!-- <span class="shadow-input1 placeholder"></span> -->
                                </div>
                            </div>


                            <div class="row">
                                  <div class="wrap-input1 validate-input col-md-6" data-validate = "nickname is required">
                                      <input class="form-control input1" type="text" name="nickname"  value="<?php echo !empty($postData1['nickname'])?$postData1['nickname']:''; ?>" placeholder="NickName" >
                                      <!-- <span class="shadow-input1 placeholder"></span> -->
                                  </div>

                            </div>

                            <?php
                            //Fetches all departments on branch selections

                            $FetchBranchDepartment = $_SESSION['BranchDepartment'];
                            // print_r($FetchBranchDepartment);

                            // Prepare departments grouped by CompanyID
                            $departmentsByCompany = [];

                            if (!empty($FetchBranchDepartment['Companies'])) {
                                foreach ($FetchBranchDepartment['Companies'] as $branch) {
                                    $branchID = $branch['CompanyID'];
                                    $departmentsByCompany[$branchID] = []; // Initialize the array for the branch


                                    foreach ($FetchBranchDepartment['CompanyDepartments'] as $department) {
                                        if ($department['CompanyID'] == $branchID) {
                                            $departmentsByCompany[$branchID][] = [
                                                  'CompanyID' => $department['CompanyID'],
                                                'DepartmentName' => $department['DepartmentName']
                                            ];
                                        }
                                    }

                                    // Sort the departments for this branch alphabetically by DepartmentName
                                    usort($departmentsByCompany[$branchID], function ($a, $b) {
                                        return strcmp($a['DepartmentName'], $b['DepartmentName']);
                                    });
                                }
                            }

                            ?>


                            <div class="row">
                              <!-- Branch Dropdown -->
                                <div class="wrap-input1 validate-input col-md-6" data-validate = "Branch is required">
                                      <select id="branch" name="branch"  class="browser-default form-select input1"  onchange="loadDepartments(this.value, '#department');"  required >
                                        <option value="" disabled selected>Branch</option>

                                        <?php
                                        // $FetchBranchDepartment = $_SESSION['BranchDepartment'];

                                        // Sort the companies by CompanyID
                                        usort($FetchBranchDepartment['Companies'], function ($a, $b) {
                                            return $a['CompanyID'] <=> $b['CompanyID']; // For numeric comparison
                                        });

                                        foreach ($FetchBranchDepartment['Companies'] as $branch) {
                                            $branchID = htmlspecialchars($branch['CompanyID']);
                                            $branchValue = htmlspecialchars($branchID . ' - ' . $branch['CompanyName']);
                                            echo '<option value="' . $branchValue . '">' . $branchValue . '</option>';
                                        }

                                        ?>
                                      </select>
                                </div>

                                <!-- Department Dropdown -->
                                <div class="wrap-input1 validate-input col-md-6" data-validate="Department is required">
                                    <select id="department" name="department" class="browser-default form-select input1" required>
                                        <option value="" disabled selected>Department</option>
                                    </select>
                               </div>
                            </div>


                      <div id="showhideAddress">
                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Address is required"  id="address">
                                     <input type="text" class="form-control input1" name="address" id="address"  placeholder="Address" value="<?php echo !empty($postData1['address'])?$postData1['address']:''; ?>"   required>
                                     <!-- <span class="shadow-input1 placeholder"></span> -->
                                </div>

                                 <div class="wrap-input1 validate-input col-md-6" data-validate = "City is required" id="city">
                                      <input type="text" class="form-control input1" name="city" id="city"  placeholder="City" value="<?php echo !empty($postData1['city'])?$postData1['city']:''; ?>"   required>
                                      <!-- <span class="shadow-input1 placeholder"></span> -->
                                 </div>
                            </div>

                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6"   data-validate = "State is required" id="state">
                                  <select name="state"  class="browser-default form-select input1" id="state"  required>
                                    <option value="" disabled selected>State</option>
                                    <option value="AK">Alaska</option>
                                    <option value="AL">Alabama</option>
                                    <option value="AR">Arkansas</option>
                                    <option value="AZ">Arizona</option>
                                    <option value="CA">California</option>
                                    <option value="CO">Colorado</option>
                                    <option value="CT">Connecticut</option>
                                    <option value="DC">District of Columbia</option>
                                    <option value="DE">Delaware</option>
                                    <option value="FL">Florida</option>
                                    <option value="GA">Georgia</option>
                                    <option value="HI">Hawaii</option>
                                    <option value="IA">Iowa</option>
                                    <option value="ID">Idaho</option>
                                    <option value="IL">Illinois</option>
                                    <option value="IN">Indiana</option>
                                    <option value="KS">Kansas</option>
                                    <option value="KY">Kentucky</option>
                                    <option value="LA">Louisiana</option>
                                    <option value="MA">Massachusetts</option>
                                    <option value="MD">Maryland</option>
                                    <option value="ME">Maine</option>
                                    <option value="MI">Michigan</option>
                                    <option value="MN">Minnesota</option>
                                    <option value="MO">Missouri</option>
                                    <option value="MS">Mississippi</option>
                                    <option value="MT">Montana</option>
                                    <option value="NC">North Carolina</option>
                                    <option value="ND">North Dakota</option>
                                    <option value="NE">Nebraska</option>
                                    <option value="NH">New Hampshire</option>
                                    <option value="NJ">New Jersey</option>
                                    <option value="NM">New Mexico</option>
                                    <option value="NV">Nevada</option>
                                    <option value="NY">New York</option>
                                    <option value="OH">Ohio</option>
                                    <option value="OK">Oklahoma</option>
                                    <option value="OR">Oregon</option>
                                    <option value="PA">Pennsylvania</option>
                                    <option value="PR">Puerto Rico</option>
                                    <option value="RI">Rhode Island</option>
                                    <option value="SC">South Carolina</option>
                                    <option value="SD">South Dakota</option>
                                    <option value="TN">Tennessee</option>
                                    <option value="TX">Texas</option>
                                    <option value="UT">Utah</option>
                                    <option value="VA">Virginia</option>
                                    <option value="VT">Vermont</option>
                                    <option value="WA">Washington</option>
                                    <option value="WI">Wisconsin</option>
                                    <option value="WV">West Virginia</option>
                                    <option value="WY">Wyoming</option>
                                  </select>
                                </div>


                                <div class="wrap-input1 validate-input col-md-6" data-validate = "5 Digit Zipcode is required"  id="zip">
                                    <!-- <label for="inputZip">Zip</label> -->
                                    <input type="text" class="form-control input1" name="zip" id="zip" onkeypress="return isNumberKey(event)"  placeholder="Zip Code" pattern="[0-9]*" maxlength="5"  value="<?php echo !empty($postData1['zip'])?$postData1['zip']:''; ?>"   required>
                                    <!-- <span class="shadow-input1 placeholder"></span> -->
                                </div>

                            </div>


                            <div class="row">
                                    <div class="wrap-input1 validate-input col-md-6" data-validate = "Phone No. is required" id="telephone">
                                        <input class="form-control input1" type="text"  name="telephone" id="telephone"  value="<?php echo !empty($postData1['telephone'])?$postData1['telephone']:''; ?>" placeholder="Telephone" onKeyup="formatPhone(this);" maxlength="12" pattern="^\D?(\d{3})\D?\D?(\d{3})\D?(\d{4})$"   required>
                                        <!-- <span class="shadow-input1 placeholder"></span> -->
                                    </div>

                                    <!-- <div class="wrap-input1 validate-input col-md-6" data-validate = "Valid email is required: ex@abc.xyz">
                                        <input class="form-control input1" type="email" name="from_email" id="from_email" value="<?php echo !empty($postData1['from_email'])?$postData1['from_email']:''; ?>" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" placeholder="Email" required>
                                        <span class="shadow-input1"></span>
                                    </div> -->
                            </div>

                      </div><!-- Show Hide Address div closed -->


                      <div style="display:none"  id="showHideEmpID">


                      <div class="row">
                        <div class="wrap-input1 validate-input col-md-6" data-validate = "Employee ID is required">
                           <input class="form-control input1" type="text" name="employeeID"  id="employeeID"  onkeypress="return isNumberKey(event)"  pattern="[0-9]*"  value="<?php echo !empty($postData1['employeeID'])?$postData1['employeeID']:''; ?>" placeholder="Employee ID"   required >
                           <!-- <span class="shadow-input1 placeholder"></span> -->
                        </div>
                      </div>
                      </div>



                             <div class="row">
                               <div class="wrap-input1 col-md-12 form-group">
                                  <input type="file" name="attachment" class="form-control input1 attachments" multiple="multiple">
                              </div>
                             </div>

                         <br />


<!-- NEW HIRE SECTION -->
     <div id="newhireSection" style="display:none" class="row">

        <fieldset class="NewHireSection scheduler-border"><br />
            <legend class="scheduler-border">NEW HIRE</legend>
             <h6 style="margin-top:-10px">FILL OUT ALL INFORMATION FOR NEW HIRE SET UP</h6>

              <div class="row">
                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Hire Reason is required">
                        <select  name="Hire_Reason" id="Hire_Reason"   class="browser-default form-select input1" >
                          <option value="">Hire Reason</option>
                          <option value="New Hire">New Hire</option>
                          <option value="Rehire">Rehire</option>
                          <option value="Replacement">Replacement For</option>
                        </select>
                  </div>

                  <div class="wrap-input1 validate-input col-md-6" >
                      <input class="form-control input1" type="text" name="replacement_for"  id="replacement_for" value="<?php echo !empty($postData1['replacement_for'])?$postData1['replacement_for']:''; ?>" placeholder="Replacement Name"  disabled>
                      <!-- <span class="shadow-input1 placeholder"></span> -->
                  </div>
              </div>


              <div class="row">
                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Employment Status is required">
                        <select  name="employment_Status"  id="employment_Status" class="browser-default form-select input1"  >
                          <option value="">Employment Status</option>
                          <option value="Full-time Regular">Full-time Regular</option>
                          <option value="Full-time Temporary">Full-time Temporary</option>
                          <option value="Part-time Regular">Part-time Regular</option>
                          <option value="Part-time Temporary">Part-time Temporary</option>
                        </select>
                  </div>

                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Drivers License No. is required">
                       <input type="text" class="form-control input1" name="drivers_License"  id="drivers_License"  onkeypress="return isNumberKey(event)"  placeholder="Drivers License #" value="<?php echo !empty($postData1['drivers_License'])?$postData1['drivers_License']:''; ?>"   >
                  </div>
             </div>

             <div class="row">
                 <div class="wrap-input1 validate-input col-md-6" data-validate = "State of Issuance is required">
                   <select name="state_Issued"  id="state_Issued"  class="browser-default form-select input1"    >
                     <option value="">State of Issuance</option>
                     <option value="AK">Alaska</option>
                     <option value="AL">Alabama</option>
                     <option value="AR">Arkansas</option>
                     <option value="AZ">Arizona</option>
                     <option value="CA">California</option>
                     <option value="CO">Colorado</option>
                     <option value="CT">Connecticut</option>
                     <option value="DC">District of Columbia</option>
                     <option value="DE">Delaware</option>
                     <option value="FL">Florida</option>
                     <option value="GA">Georgia</option>
                     <option value="HI">Hawaii</option>
                     <option value="IA">Iowa</option>
                     <option value="ID">Idaho</option>
                     <option value="IL">Illinois</option>
                     <option value="IN">Indiana</option>
                     <option value="KS">Kansas</option>
                     <option value="KY">Kentucky</option>
                     <option value="LA">Louisiana</option>
                     <option value="MA">Massachusetts</option>
                     <option value="MD">Maryland</option>
                     <option value="ME">Maine</option>
                     <option value="MI">Michigan</option>
                     <option value="MN">Minnesota</option>
                     <option value="MO">Missouri</option>
                     <option value="MS">Mississippi</option>
                     <option value="MT">Montana</option>
                     <option value="NC">North Carolina</option>
                     <option value="ND">North Dakota</option>
                     <option value="NE">Nebraska</option>
                     <option value="NH">New Hampshire</option>
                     <option value="NJ">New Jersey</option>
                     <option value="NM">New Mexico</option>
                     <option value="NV">Nevada</option>
                     <option value="NY">New York</option>
                     <option value="OH">Ohio</option>
                     <option value="OK">Oklahoma</option>
                     <option value="OR">Oregon</option>
                     <option value="PA">Pennsylvania</option>
                     <option value="PR">Puerto Rico</option>
                     <option value="RI">Rhode Island</option>
                     <option value="SC">South Carolina</option>
                     <option value="SD">South Dakota</option>
                     <option value="TN">Tennessee</option>
                     <option value="TX">Texas</option>
                     <option value="UT">Utah</option>
                     <option value="VA">Virginia</option>
                     <option value="VT">Vermont</option>
                     <option value="WA">Washington</option>
                     <option value="WI">Wisconsin</option>
                     <option value="WV">West Virginia</option>
                     <option value="WY">Wyoming</option>
                   </select>
                 </div>

                 <!-- <div class="wrap-input1 validate-input col-md-6 date" data-validate = "DOB is required" data-provide="datepicker" data-date-format="mm/dd/yyyy">
                   <input class="form-control input1 date-withicon" type="text"  name="date_of_Birth"  id="date_of_Birth"   placeholder="DOB" onblur = "ValidateDOB(); return ValidateDOB();"  value="<?php echo !empty($postData1['date_of_Birth'])?$postData1['date_of_Birth']:''; ?>" >
                    <div class="input-group-addon"></div> <span class="error" id="lblError" style="color:#DC3545; font-weight:bold"></span>
                 </div> -->


                 <div class="wrap-input1 validate-input col-md-6 date" data-validate = "DOB is required" >
                   <input class="form-control input1 date-withicon" type="text"  name="date_of_Birth"  id="date_of_Birth"   placeholder="DOB" onblur="ValidateDOB();"  value="<?php echo !empty($postData1['date_of_Birth'])?$postData1['date_of_Birth']:''; ?>" >
                    <span class="input-group-addon placeholder"></span> <span class="error" id="lblError" style="color:#DC3545; font-weight:bold; font-size:12px; padding-left:10px; display:none"></span>
                 </div>

             </div>


             <div class="row">
                 <div class="wrap-input1 validate-input col-md-6"   data-validate = "Gender is required">

                       <select  name="gender"  id="gender"  class="browser-default form-select input1"  >
                         <option value="">Gender</option>
                         <option value="Male">Male</option>
                         <option value="Female">Female</option>
                       </select>
                 </div>

                 <div class="wrap-input1 validate-input col-md-6"   data-validate = "Ethnic Code is required">

                       <select  name="ethnic_Code"  id="ethnic_Code"  class="browser-default form-select input1"  >
                         <option value="">Ethnic Code</option>
                         <option value="American Indian or Alaskia">American Indian or Alaskia</option>
                         <option value="Asian">Asian</option>
                         <option value="Black">Black</option>
                         <option value="Hawaiian pacific isl">Hawaiian/Pacific Isl</option>
                         <option value="Hispanic Latino">Hispanic/Latino</option>
                         <option value="Multi">Multi</option>
                         <option value="Unknown">Unknown</option>
                         <option value="White/Caucasian">White/Caucasian</option>
                       </select>
                 </div>
            </div>


            <div class="row">
                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Marital Status is required">

                      <select  name="marital_Status"  id="marital_Status"  class="browser-default form-select input1"  >
                        <option value="">Marital Status</option>
                        <option value="Divorced">Divorced</option>
                        <option value="Domestic Partner">Domestic Partner</option>
                        <option value="Married">Married</option>
                        <option value="Separated">Separated</option>
                        <option value="Single">Single</option>
                        <option value="Widowed">Widowed</option>
                        <option value="Unknown">Unknown</option>
                      </select>
                </div>

                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Job Title is required">

                      <select  name="job_Title" id="job_Title"  class="browser-default form-select input1"  >

                        <option value="">Job Title</option>
                        <?php
                          // Getting the job titles from DB
                          $FetchJobTitles = $_SESSION['job_Title'];

                          // Extract the HierarchyName values and store them in a separate array
                          $job_Titles = array_column($FetchJobTitles['Items'], 'TitleDescription');

                          // Sort the HierarchyName values alphabetically
                           sort($job_Titles);
                          // Loop through each item in the session array to get the HierarchyName
                           foreach ($job_Titles as $job_Title) {
                              // $hierarchyName = $item['HierarchyName'];
                              echo '<option value="' . htmlspecialchars($job_Title) . '">' . htmlspecialchars($job_Title) . '</option>';
                          }
                          ?>


                      </select>
                </div>
           </div>

           <div class="row">
               <div class="wrap-input1 validate-input col-md-6" data-validate = "Starting Rate is required">
                   <input type="text" class="form-control input1" name="starting_Rate"  id="starting_Rate" placeholder="Starting Rate" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($postData1['starting_Rate'])?$postData1['starting_Rate']:''; ?>"   >
               </div>

               <div class="wrap-input1 validate-input col-md-6"   data-validate = "Per is required">
                     <select  name="per"  id="per"  class="browser-default form-select input1" >
                       <option value="" disabled selected>Per</option>
                       <option value="Annum">Annum</option>
                       <option value="Hour">Hour</option>
                       <option value="Week">Week</option>
                     </select>
               </div>
          </div>

          <div class="row">
              <div class="wrap-input1 validate-input col-md-6"   data-validate = "Bonus/Commission is required">
                    <select  name="bonus_Commission_Plan" id="bonus_Commission_Plan"  class="browser-default form-select input1" >
                      <option value="" disabled selected>Bonus or Commission Plan ? </option>
                      <option value="Bonus">Bonus</option>
                      <option value="Commission">Commission</option>
                      <option value="Neither">Neither</option>
                    </select>
              </div>

              <div class="wrap-input1  col-md-6"   data-validate = "Bonus Level is required">
                    <select  name="bonus_Level"  id="bonus_Level"  class="browser-default form-select input1" >
                      <option value="" disabled selected>Bonus Level</option>
                      <option value="1">1</option>
                      <option value="2">2</option>
                      <option value="3">3</option>
                    </select>
                    <!-- <input hidden name="bonusLevel" value="None"/> -->
              </div>
         </div>


        <script>

            $(document).ready(function() {
                // Prevent dropdown from closing when clicking on checkboxes
                $('.dropdown-menu').on('click', function(event) {
                  event.stopPropagation();
                });

                // Update button text based on selected options
                $('.dropdown-menu input[type="checkbox"]').on('change', function() {
                  var selectedOptions = [];
                  $('.dropdown-menu input[type="checkbox"]:checked').each(function() {
                    selectedOptions.push($(this).val());
                  });

                  if (selectedOptions.length > 0) {
                    $('#Training_Needed').text(selectedOptions.join(', '));
                  } else {
                    $('#Training_Needed').text('Training Needed');
                  }
                });

                // Allow the dropdown to open again after selection
                $('#Training_Needed').on('click', function() {
                  $(this).dropdown('toggle');
                });
              });

        </script>

        <div class="row">

          <div class="wrap-input1 col-md-6" data-validate="Training Needed is required" style="position: relative;">
            <div class="dropdown">
              <button class="multi-list dropdown-toggle browser-default form-select input1" type="button" id="Training_Needed" name="Training_Needed" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Training Needed
              </button>
              <div class="dropdown-menu" aria-labelledby="Training_Needed">
                <div class="px-3 py-2">
                  <input type="checkbox" id="option1" name="Training_Needed[]" value="DTNA-ARC">
                  <label for="option1">DTNA-ARC</label>
                </div>
                <div class="px-3 py-2">
                  <input type="checkbox" id="option2" name="Training_Needed[]" value="DTNA-Dealer Personnel Information">
                  <label for="option2">DTNA-Dealer Personnel Information</label>
                </div>
                <div class="px-3 py-2">
                  <input type="checkbox" id="option3" name="Training_Needed[]"  value="DTNA-OWL">
                  <label for="option3">DTNA-OWL</label>
                </div>
                <div class="px-3 py-2">
                  <input type="checkbox" id="option4" name="Training_Needed[]"  value="DTNA-Paragon">
                  <label for="option4">DTNA-Paragon</label>
                </div>
                <div class="px-3 py-2">
                  <input type="checkbox" id="option5" name="Training_Needed[]"  value="DTNA-Parts Pro">
                  <label for="option5">DTNA-Parts Pro</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option6" name="Training_Needed[]"  value="DTNA-SpecPro">
                  <label for="option6">DTNA-SpecPro</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option7" name="Training_Needed[]"  value="DTNA-TSS Plus">
                  <label for="option7">DTNA-TSS Plus</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option8" name="Training_Needed[]"  value="DTNA-Virtual Technician">
                  <label for="option8">DTNA-Virtual Technician</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option9" name="Training_Needed[]"  value="Adjust Rite">
                  <label for="option9">Adjust Rite</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option10" name="Training_Needed[]"  value="Autocar">
                  <label for="option10">Autocar</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option11" name="Training_Needed[]"  value="Carrier">
                  <label for="option11">Carrier</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option12" name="Training_Needed[]"  value="Caterpillar">
                  <label for="option12">Caterpillar</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option13" name="Training_Needed[]"  value="Cummins Commerce">
                  <label for="option13">Cummins Commerce</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option14" name="Training_Needed[]"  value="Cummins QuikServ">
                  <label for="option14">Cummins QuikServ</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option15" name="Training_Needed[]"  value="Cummins RSW">
                  <label for="option15">Cummins RSW</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option16" name="Training_Needed[]"  value="Donaldson">
                  <label for="option16">Donaldson</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option17" name="Training_Needed[]"  value="Duralite">
                  <label for="option17">Duralite</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option18" name="Training_Needed[]"  value="Eaton">
                  <label for="option18">Eaton</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option19" name="Training_Needed[]"  value="Fleetguard">
                  <label for="option19">Fleetguard</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option20" name="Training_Needed[]"  value="Fuso">
                  <label for="option20">Fuso</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option21" name="Training_Needed[]"  value="MCC-Warranty">
                  <label for="option21">MCC-Warranty</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option22" name="Training_Needed[]"  value="NetStar">
                  <label for="option22">NetStar</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option23" name="Training_Needed[]"  value="TBB Online">
                  <label for="option23">TBB Online</label>
                </div>

                <div class="px-3 py-2">
                  <input type="checkbox" id="option24" name="Training_Needed[]"  value="TXDot">
                  <label for="option24">TXDot</label>
                </div>

              </div>
            </div>
          </div>


          <div class="wrap-input1 validate-input col-md-6"   data-validate = "Technician Shifts is required">
                    <select  name="Technician_Shift" id="Technician_Shift"  class="browser-default form-select input1">
                           <option value="">Technician Shift</option>
                           <?php

                           $Technician_Shifts = $_SESSION['Technician_Shift'];

                           // Extract the HierarchyName values and store them in a separate array
                           $Technician_Shifts = array_column($Technician_Shifts['Items'], 'Description');

                           // Sort the HierarchyName values alphabetically
                           sort($Technician_Shifts);
                           // Loop through each item in the session array to get the HierarchyName
                            foreach ($Technician_Shifts as $Technician_Shift) {

                               echo '<option value="' . htmlspecialchars($Technician_Shift) . '">' . htmlspecialchars($Technician_Shift) . '</option>';
                           }
                           ?>
                    </select>
              </div>

          </div>

          <div class="row">

           <div class="wrap-input1 validate-input col-md-6" data-validate="Hierarchy Name is required">
             <?php if (isset($_SESSION['api_error'])) : ?>
                <div class="alert alert-danger">
                    <?= htmlspecialchars($_SESSION['api_error']); ?>
                </div>

                <?php
                // Clear the error after displaying it
                unset($_SESSION['api_error']);
                ?>
             <?php else: ?>

              <select name="Hierarchy_Name" id="Hierarchy_Name" class="browser-default form-select input1">
                  <option value="">Hierarchy Name</option>
                  <?php

                  $FetchHierarchies = $_SESSION['Hierarchy_Name'];

                  // Extract the HierarchyName values and store them in a separate array
                  $hierarchyNames = array_column($FetchHierarchies['Items'], 'HierarchyName');

                  // Sort the HierarchyName values alphabetically
                  sort($hierarchyNames);
                  // Loop through each item in the session array to get the HierarchyName
                   foreach ($hierarchyNames as $hierarchyName) {
                      // $hierarchyName = $item['HierarchyName'];
                      echo '<option value="' . htmlspecialchars($hierarchyName) . '">' . htmlspecialchars($hierarchyName) . '</option>';
                  }
                  ?>
              </select>

              <?php endif; ?>
          </div>
        </div>


        <div class="row">
            <div class="wrap-input1 form-group col-md-6"  id="ShowHideAlarmCode">
               <div class="form-check form-check-inline">
                 <label id="Alarm_Code_Label">Need Alarm Code?</label><br />
                 <input class="form-check-input" type="radio" value="Yes" name="Alarm_Code" id="Alarm_Code">
                 <label class="form-check-label" for="Alarm_Code">Yes</label>
               <!-- </div> -->
              <!-- <div class="form-check form-check-inline"> -->
                 <input class="form-check-input" type="radio" value="No" name="Alarm_Code" id="Alarm_Code">
                 <label class="form-check-label" for="Alarm_Code">No</label>
              </div>
            </div>

            <div class="wrap-input1 form-group col-md-6"  id="ShowHideNeedWorkstation">
               <div class="form-check form-check-inline">
                 <label id="Need_Workstation_Label">Need Workstation? Eg. Laptop, Surface</label><br />
                 <input class="form-check-input" type="radio" value="Yes" name="Need_Workstation" id="Need_Workstation" required>
                 <label class="form-check-label" for="Need_Workstation">Yes</label>
               <!-- </div> -->
              <!-- <div class="form-check form-check-inline"> -->
                 <input class="form-check-input" type="radio" value="No" name="Need_Workstation" id="Need_Workstation" required>
                 <label class="form-check-label" for="Need_Workstation">No</label>
              </div>
            </div>
        </div>


        <!-- Remarks -->
          <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
              <h6 style="margin-bottom:3px; text-transform: uppercase;">Use the remarks section below to note any specific usage rights or logins needed for this employee</h6>
              <textarea class="form-control input1" name="New_Hire_Remarks"   id="New_Hire_Remarks"  placeholder="Remarks"><?php echo !empty($postData['New_Hire_Remarks'])?$postData['New_Hire_Remarks']:''; ?></textarea>
              <span class="shadow-input1"></span>
          </div>


       </fieldset>

  </div><!-- END OF Newhire Section Div -->


  <!-- CHANGE SECTION -->
  <div id="changeSection" style="display:none" class="row">

    <!-- <div id="change"> -->
       <fieldset class="ChangeSection scheduler-border">
           <legend class="scheduler-border">CHANGE</legend>
           <h6 style="margin-top:-5px">CHECK THE APPLICABLE OPTIONS & EXPLAIN IN THE REMARKS SECTION IF NECESSARY</h6>

           <div id="checkboxesCheckError" style='color:red; font-weight:bold'></div><br />


           <!-- JOB TITLE -->
          <div class="row">
               <div class="wrap-input1 validate-input col-md-4">
                  <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="jobTitleCheckbox" >
                  <label class="form-check-label" for="jobTitleCheckbox">Job Title</label>
               </div>


                <!-- <span style="margin:17px 0; font-weight:bold; color:#666">From:</span> -->
                 <div class="wrap-input1 validate-input col-md-4"   data-validate = "Job Title is required">
                   <!-- <label class="mdb-main-label">From:</label> -->
                   <label for="Job_Title_From">From:</label>
                       <select  name="Job_Title_From"  id="Job_Title_From" class="browser-default form-select input1"   disabled required>
                         <option value="" disabled selected>Job Title</option>

                         <?php
                         // Getting the job titles from DB
                         $FetchJobTitles = $_SESSION['job_Title'];

                         // Extract the HierarchyName values and store them in a separate array
                         $job_Titles = array_column($FetchJobTitles['Items'], 'TitleDescription');

                         // Sort the jobtitle values alphabetically
                         sort($job_Titles);
                         // Loop through each item in the session array to get the jobtitle
                         foreach ($job_Titles as $Job_Title_From) {
                             echo '<option value="' . htmlspecialchars($Job_Title_From) . '">' . htmlspecialchars($Job_Title_From) . '</option>';
                         }
                         ?>

                       </select>

                 </div>


                 <!-- <span style="margin:5px 0; font-weight:bold; color:#666">To:</span> -->
                 <div class="wrap-input1 validate-input col-md-4"   data-validate = "Job Title is required">
                   <label for="Job_Title_To">To:</label>
                       <select  name="Job_Title_To" id="Job_Title_To"  class="browser-default form-select input1"  disabled required>
                         <option value="" disabled selected>Job Title</option>

                         <?php
                         // Getting the job titles from DB
                         $FetchJobTitles = $_SESSION['job_Title'];

                         // Extract the HierarchyName values and store them in a separate array
                         $job_Titles = array_column($FetchJobTitles['Items'], 'TitleDescription');

                         // Sort the Jobtitle values alphabetically
                         sort($job_Titles);

                         // Loop through each item in the session array to get the jobtitle
                         foreach ($job_Titles as $Job_Title_To) {
                            echo '<option value="' . htmlspecialchars($Job_Title_To) . '">' . htmlspecialchars($Job_Title_To) . '</option>';
                         }
                         ?>

                       </select>

                     </div>

             </div>


             <!-- PAY -->
             <div class="row">
                  <div class="wrap-input1 validate-input col-md-4">
                     <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="PayCheckbox" >
                     <label class="form-check-label" for="PayCheckbox">Pay</label>
                  </div>


            <!-- Pay from -->
                      <div class="wrap-input1 validate-input col-md-4" data-validate = "Pay From is required">
                          <label for="Pay_From">From:</label>
                          <input type="text" class="form-control input1" name="Pay_From" id="Pay_From"  placeholder="Pay From" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($postData1['Pay_From'])?$postData1['Pay_From']:''; ?>"   disabled required>
                      </div>

                      <div class="wrap-input1 validate-input col-md-4"   data-validate = "Pay From Per is required">
                        <label for="Pay_From_Per">Per:</label>
                            <select  name="Pay_From_Per" id="Pay_From_Per"  class="browser-default form-select input1"  disabled required>
                              <option value="" disabled selected>Per</option>
                              <option value="Annum">Annum</option>
                              <option value="Hour">Hour</option>
                              <option value="Week">Week</option>

                            </select>
                      </div>
              </div>

            <!-- Pay To -->
            <div class="row">
              <div class="wrap-input1 validate-input col-md-4"></div>
                <div class="wrap-input1 validate-input col-md-4" data-validate = "Pay To is required">
                    <label for="Pay_To">To:</label>
                    <input type="text" class="form-control input1" name="Pay_To" id="Pay_To"  placeholder="Pay To" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($postData1['Pay_To'])?$postData1['Pay_To']:''; ?>"   disabled required>
                </div>

                <div class="wrap-input1 validate-input col-md-4"   data-validate = "Per To is required">
                  <label for="Pay_To_Per">Per:</label>
                      <select  name="Pay_To_Per" id="Pay_To_Per"  class="browser-default form-select input1"  disabled required>
                        <option value="" disabled selected>Per</option>
                        <option value="Annum">Annum</option>
                        <option value="Hour">Hour</option>
                        <option value="Week">Week</option>
                      </select>
                </div>
            </div>


            <?php

              ///Fetches all departments on branch selections
              $FetchBranchDepartment = $_SESSION['BranchDepartment'];
              // print_r($FetchBranchDepartment);

              // Prepare departments grouped by CompanyID
              $departmentsByCompany = [];

              if (!empty($FetchBranchDepartment['Companies'])) {
                  foreach ($FetchBranchDepartment['Companies'] as $branch) {
                      $branchID = $branch['CompanyID'];
                      $departmentsByCompany[$branchID] = []; // Initialize the array for the branch


                      foreach ($FetchBranchDepartment['CompanyDepartments'] as $department) {
                          if ($department['CompanyID'] == $branchID) {
                              $departmentsByCompany[$branchID][] = [
                                    'CompanyID' => $department['CompanyID'],
                                  'DepartmentName' => $department['DepartmentName']
                              ];
                          }
                      }

                      // Sort the departments for this branch alphabetically by DepartmentName
                      usort($departmentsByCompany[$branchID], function ($a, $b) {
                          return strcmp($a['DepartmentName'], $b['DepartmentName']);
                      });
                  }
              }

             ?>


            <!-- BRANCH -->
            <div class="row">
                 <div class="wrap-input1 validate-input col-md-4">
                    <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="BranchCheckbox" >
                    <label class="form-check-label" for="BranchCheckbox">Branch & <br />Department</label>
                 </div>

                 <div class="wrap-input1 validate-input col-md-4" data-validate = "From Branch is required">
                      <label for="From_Branch">From:</label>
                       <select id="From_Branch" name="From_Branch"  class="browser-default form-select input1"  onchange="loadDepartments(this.value, '#From_Department');"  disabled required>
                            <option value="" disabled selected>Branch</option>

                          <?php

                             $FetchBranchDepartment = $_SESSION['BranchDepartment'];

                             // Sort the companies by CompanyID
                             usort($FetchBranchDepartment['Companies'], function ($a, $b) {
                                  return $a['CompanyID'] <=> $b['CompanyID']; // For numeric comparison
                             });


                             foreach ($FetchBranchDepartment['Companies'] as $branch) {
                                 $branchID = htmlspecialchars($branch['CompanyID']);
                                 $branchValue = htmlspecialchars($branchID . ' - ' . $branch['CompanyName']);
                                 echo '<option value="' . $branchValue . '">' . $branchValue . '</option>';
                             }

                           ?>
                       </select>
                 </div>

                 <div class="wrap-input1 validate-input col-md-4" data-validate = "To Branch is required">
                      <label for="To_Branch">To:</label>
                       <select id="To_Branch" name="To_Branch"  class="browser-default form-select input1"   disabled required>
                         <option value="" disabled selected>Branch</option>
                           <?php
                              $FetchBranchDepartment = $_SESSION['BranchDepartment'];

                              // Sort the companies by CompanyID
                              usort($FetchBranchDepartment['Companies'], function ($a, $b) {
                                   return $a['CompanyID'] <=> $b['CompanyID']; // For numeric comparison
                              });

                              foreach ($FetchBranchDepartment['Companies'] as $branch) {
                                  $branchID = htmlspecialchars($branch['CompanyID']);
                                  $branchValue = htmlspecialchars($branchID . ' - ' . $branch['CompanyName']);
                                  usort($branchValue);
                                  echo '<option value="' . $branchValue . '">' . $branchValue . '</option>';

                             }

                        ?>
                       </select>
                 </div>
           </div>

           <!-- Department -->
           <div class="row">
                <div class="wrap-input1 validate-input col-md-4">
                   <!-- <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="DepartmentCheckbox" >
                   <label class="form-check-label" for="DepartmentCheckbox">Department</label> -->
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "From Department is required">
                     <label for="From_Department">From:</label>
                     <select  name="From_Department" id="From_Department"  class="browser-default form-select input1"    disabled required>
                       <option value="" disabled selected>Department</option>

                     </select>
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "To Department is required">
                     <label for="To_Department">To:</label>
                     <select  name="To_Department"  id="To_Department" class="browser-default form-select input1"   disabled required>
                       <option value="" disabled selected>Department</option>

                     </select>
                </div>
          </div>


          <!-- Employment Status -->
          <div class="row">
               <div class="wrap-input1 validate-input col-md-4">
                  <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="EmpStatusCheckbox" >
                  <label class="form-check-label" for="EmpStatusCheckbox">Employment <br />Status</label>
               </div>

               <div class="wrap-input1 validate-input col-md-4" data-validate = "From Department is required">
                    <label for="From_Employee_Status">From:</label>
                    <select  name="From_Employee_Status" id="From_Employee_Status"   class="browser-default form-select input1"  disabled required>
                      <option value="" disabled selected>Employment Status</option>
                      <option value="Full-time Regular">Full-time Regular</option>
                      <option value="Full-time Temporary">Full-time Temporary</option>
                      <option value="FMLA">FMLA</option>
                      <option value="Light Duty">Light Duty</option>
                      <option value="Part-time Regular">Part-time Regular</option>
                      <option value="Part-time Temporary">Part-time Temporary</option>
                      <option value="USERRA">USERRA</option>
                      <option value="Other Leave">Other Leave</option>
                    </select>
               </div>

               <div class="wrap-input1 validate-input col-md-4" data-validate = "To Department is required">
                    <label for="To_Employee_Status">To:</label>
                    <select  name="To_Employee_Status"  id="To_Employee_Status"  class="browser-default form-select input1"  disabled required>
                      <option value="" disabled selected>Employment Status</option>
                      <option value="Full-time Regular">Full-time Regular</option>
                      <option value="Full-time Temporary">Full-time Temporary</option>
                      <option value="FMLA">FMLA</option>
                      <option value="Light Duty">Light Duty</option>
                      <option value="Part-time Regular">Part-time Regular</option>
                      <option value="Part-time Temporary">Part-time Temporary</option>
                      <option value="USERRA">USERRA</option>
                      <option value="Other Leave">Other Leave</option>
                    </select>
               </div>
         </div>


         <div class="row">
             <div class="wrap-input1 validate-input col-md-4">
                <input class="form-check-input1 changeChkbox" type="checkbox" value="" id="HierarchyNameCheckbox" >
                <label class="form-check-label" for="HierarchyNameCheckbox">Hierarchy <br />Name</label>

                <!-- warningMessage show/hide in JS file -->
               <p id="warningMessage" class='alert alert-danger HierarchyWarningMessage' style="display:none">
                  If you need to modify or create a new hierarchy, please abandon this form and submit a Phoenix Helpdesk using the button above.
              </p>
             </div>


              <!-- <span style="margin:17px 0; font-weight:bold; color:#666">From:</span> -->
               <div class="wrap-input1 validate-input col-md-4"   data-validate = "Hierarchy_Name_From is required">
                 <!-- <label class="mdb-main-label">From:</label> -->
                 <label for="Hierarchy_Name_From">From:</label>
                     <select  name="Hierarchy_Name_From"  id="Hierarchy_Name_From" class="browser-default form-select input1"   disabled required>
                       <option value="" disabled selected>Hierarchy Name</option>

                       <?php

                       $FetchHierarchies = $_SESSION['Hierarchy_Name'];

                       // Extract the HierarchyName values and store them in a separate array
                       $hierarchyNames = array_column($FetchHierarchies['Items'], 'HierarchyName');

                       // Sort the HierarchyName values alphabetically
                       sort($hierarchyNames);
                       // Loop through each item in the session array to get the HierarchyName
                        foreach ($hierarchyNames as $Hierarchy_Name_From) {
                           // $hierarchyName = $item['HierarchyName'];
                           echo '<option value="' . htmlspecialchars($Hierarchy_Name_From) . '">' . htmlspecialchars($Hierarchy_Name_From) . '</option>';
                       }

                       ?>

                     </select>

               </div>


               <!-- <span style="margin:5px 0; font-weight:bold; color:#666">To:</span> -->
               <div class="wrap-input1 validate-input col-md-4"   data-validate = "Hierarchy_Name_To is required">
                 <label for="Hierarchy_Name_To">To:</label>
                     <select  name="Hierarchy_Name_To" id="Hierarchy_Name_To"  class="browser-default form-select input1"  disabled required>
                       <option value="" disabled selected>Hierarchy Name</option>

                       <?php

                       $FetchHierarchies = $_SESSION['Hierarchy_Name'];

                       // Extract the HierarchyName values and store them in a separate array
                       $hierarchyNames = array_column($FetchHierarchies['Items'], 'HierarchyName');

                       // Sort the HierarchyName values alphabetically
                       sort($hierarchyNames);
                       // Loop through each item in the session array to get the HierarchyName
                        foreach ($hierarchyNames as $Hierarchy_Name_To) {
                           // $hierarchyName = $item['HierarchyName'];
                           echo '<option value="' . htmlspecialchars($Hierarchy_Name_To) . '">' . htmlspecialchars($Hierarchy_Name_To) . '</option>';
                       }

                       ?>

                     </select>

                   </div>
           </div>

         <!-- Remarks -->
           <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
               <h6 style="margin-bottom:3px; text-transform: uppercase;">Use the remarks section below to note any specific usage rights or logins needed for this employee</h6>
               <textarea class="form-control input1" name="Change_Remarks" placeholder="Remarks"><?php echo !empty($postData['Change_Remarks'])?$postData['Change_Remarks']:''; ?></textarea>
               <span class="shadow-input1"></span>
           </div>


  </fieldset>

</div><!-- END OF Change Section Div -->


<!-- SEPARATION SECTION -->
<div id="separationSection" style="display:none" class="row">

  <!-- <div id="separation"> -->
     <fieldset class="SeparationSection scheduler-border"><br />
         <legend class="scheduler-border">SEPARATION</legend>

           <div class="row">
               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Hire Date is required" data-provide="datepicker" data-date-format="mm/dd/yyyy">
                 <input class="form-control input1 date-withicon" type="text"  name="Hire_Date"  id="Hire_Date"  placeholder="Hire Date"  value="<?php echo !empty($postData1['Hire_Date'])?$postData1['Hire_Date']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>

               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Last Day Worked is required" data-provide="datepicker" data-date-format="mm/dd/yyyy">
                 <input class="form-control input1 date-withicon" type="text"  name="Last_Day_Worked"  id="Last_Day_Worked"  placeholder="Last Day Worked"  value="<?php echo !empty($postData1['Last_Day_Worked'])?$postData1['Last_Day_Worked']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>

               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Separation Date is required" data-provide="datepicker" data-date-format="mm/dd/yyyy">
                 <input class="form-control input1 date-withicon" type="text"  name="Separation_Date"  id="Separation_Date"   placeholder="Separation Date"  value="<?php echo !empty($postData1['Separation_Date'])?$postData1['Separation_Date']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>
           </div>

           <div class="row">
                <div class="wrap-input1 validate-input col-md-4" data-validate = "Type is required">
                     <select  name="Separation_Type" id="Separation_Type"   class="browser-default form-select input1"  >
                       <option value="" disabled selected>Type</option>
                       <option value="Involuntary">Involuntary</option>
                       <option value="Uncontrollable">Uncontrollable</option>
                       <option value="Voluntary">Voluntary</option>
                     </select>
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "Reason is required">
                     <select  name="Separation_Reason" id="Separation_Reason"   class="browser-default form-select input1"  >
                       <option value="" disabled selected>Separation Reason</option>
                       <option value="Better Pay/Benefits">Better Pay/Benefits</option>
                       <option value="Excessive Absences">Excessive Absences</option>
                       <option value="Excessive Tardies">Excessive Tardies</option>
                       <option value="Failure To Follow Company Rules/Handbook">Failure To Follow Company Rules/Handbook</option>
                       <option value="Insubordination">Insubordination</option>
                       <option value="Involuntary">Involuntary</option>
                       <option value="Lay Off">Lay Off</option>
                       <option value="Personal Reasons Not Related To Work">Personal Reasons Not Related To Work</option>
                       <option value="Poor Performance">Poor Performance</option>
                       <option value="Retirement">Retirement</option>
                       <option value="Student Intern Not Hired - Voluntary">Student Intern Not Hired - Voluntary</option>
                       <option value="Student Intern Not Hired - Involuntary">Student Intern Not Hired - Involuntary</option>
                       <option value="Termination">Termination</option>
                       <option value="Theft">Theft</option>
                       <option value="Unknown">Unknown</option>
                       <option value="Voluntary">Voluntary</option>

                     </select>
                </div>

                <div class="wrap-input1 form-group col-md-4"  id="hideEligible">
                   <div class="form-check form-check-inline">
                     <label id="EligibleTitle">Eligible for Rehire</label><br />
                     <input class="form-check-input" type="radio" value="Yes" name="Eligible_to_Rehire" id="Eligible_to_Rehire" >
                     <label class="form-check-label" for="Eligible_to_Rehire">Yes</label>
                   <!-- </div> -->
                  <!-- <div class="form-check form-check-inline"> -->
                     <input class="form-check-input" type="radio" value="No" name="Eligible_to_Rehire" id="Eligible_to_Rehire" >
                     <label class="form-check-label" for="Eligible_to_Rehire">No</label>
                  </div>
                </div>
            </div>


             <div class="row">
              <div class="wrap-input1 form-group">
                   <div class="form-check form-check-inline col-sm-4 col-md-4">
                       <label>Forward User’s Emails?</label><br />
                       <input class="form-check-input" type="radio" value="Yes" name="forward_emails" id="forwardYes" onclick="javascript:forwardEmailtoAnotherEmpCheck();">
                       <label class="form-check-label" for="forward_emails">Yes</label>

                       <input class="form-check-input" type="radio" value="No" name="forward_emails" id="forwardNo" onclick="javascript:forwardEmailtoAnotherEmpCheck();">
                       <label class="form-check-label" for="forward_emails">No</label>
                   </div>

                   <div id="forwardingEmployee" style="display:none;">
                        <div class="wrap-input1 validate-input col-sm-8 col-md-8" data-validate = "Full Name is required">
                            <input class="form-control input1" type="text" name="forwarding_to_employee_name" id="forwarding_to_employee_name"  value="<?php echo !empty($postData1['forwarding_to_employee_name'])?$postData1['forwarding_to_employee_name']:''; ?>" placeholder="Forward to Employee Name"  required>
                            <!-- <span class="shadow-input1"></span> -->
                        </div>
                  </div>
              </div>
            </div>



          <!-- Remarks -->
            <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
                <textarea class="form-control input1" name="Separation_Remarks" id="Separation_Remarks" placeholder="Remarks"><?php echo !empty($postData['Separation_Remarks'])?$postData['Separation_Remarks']:''; ?></textarea>
                <span class="shadow-input1"></span>
            </div>

         </fieldset>

</div><!-- END OF Separation Section Div -->

<br />
                    <div class="container-contact2-form-btn">
                        <!-- <div class="form-check form-check-inline col-md-4">
                                <button class="contact2-form-btn" type="submit" name="submit3" id="submit3"  value="INSERT"  onclick='btnclick3("Personnel Action Notice","submit3","container-contact2"); valthis(); return ValidateDOB();'>
                                  <span>
                                      INSERT
                                  </span>
                                </button>
                         </div> -->
                         <div class="form-check form-check-inline">
                           <button class="contact2-form-btn" type="submit" id="submit2" name="submit2" onclick='btnclick2("Personnel Action Notice","submit2","container-contact2"); return ValidateDOB();'>
                               <span>SUBMIT<i class="fa-regular fa-circle-right" aria-hidden="true"></i></span>
                           </button>
                         </div>
                    </div>

                    <div>
                    <!-- Display Error status -->
                                <!-- <br> -->
                                <?php if(!empty($statusMsg)){ ?>
                                    <p class="statusMsg <?php echo !empty($msgClass)?$msgClass:''; ?>"><?php echo $statusMsg; ?></p>
                                <?php } ?>
                  </div><br /><br />

<!-- End of ShowHide Div -->

                </div><!-- End of target div2 -->

                </form>
              </div>  <!-- End of container-contact2 -->

    </div>
    <!-- End of scrolldiv -->

</div>
  <!-- centering the entire div -->




                    <?php
                    }
                    else
                    {

                      // echo '<script>$("#loginModal").hide();</script>';

                    ?>
                    <div align="center">
                         <!-- <button type="button" name="login" id="login" class="btn btn-success" data-toggle="modal" data-target="#loginModal">Login</button> -->
                         <!-- <button id="DivIdToScroll3" type="button" target="2" data-toggle="modal" data-target="#loginModal"  class="btn success showSingle" name="btnPN"  id="btnPN"  >PERSONNEL<br>NOTICE</button> -->
                    </div>
                    <?php
                    }
                    ?>
               </div>
           <br />

           <script>

               var departmentsByCompany = <?php echo json_encode($departmentsByCompany); ?>;

               function loadDepartments(branchValue, departmentDropdownID) {
                 // Extract the branchID from branchValue (formatted as "CompanyID - CompanyName")
                 var branchID = branchValue.split(' - ')[0];

                   console.log('Selected Branch ID:', branchID);

                   var $departmentDropdown = $(departmentDropdownID);
                   $departmentDropdown.html('<option value="" disabled selected>Select Department</option>').prop('disabled', true);

                   if (branchID && departmentsByCompany[branchID]) {
                       console.log('Matching Departments:', departmentsByCompany[branchID]);
                       $departmentDropdown.prop('disabled', false);
                       // $('#department').prop('disabled', false);

                       departmentsByCompany[branchID].forEach(function(department) {
                           console.log('Appending Department:', department.DepartmentName);
                           $departmentDropdown.append('<option value="' + department.DepartmentName + '">' + department.DepartmentName + '</option>');
                       });
                   } else {
                       console.log('No departments found for the selected branch.');
                   }
               }

               // Disable all department dropdowns on page load
               // $('#department, #From_Department, #To_Department').prop('disabled', true);
                 // $('#department, #From_Department, #To_Department').attr('disabled', 'disabled');
               $('#department').prop('disabled', true);
               $('#From_Department').prop('disabled', true);
               $('#To_Department').prop('disabled', true);

               // Handle changes for the #branch dropdown
               $('#branch').change(function() {
                   loadDepartments($(this).val(), '#department');
               });

               // Handle changes for the #From_Branch dropdown
               $('#From_Branch').change(function() {
                   loadDepartments($(this).val(), '#From_Department');
               });

               // Handle changes for the #To_Branch dropdown
               $('#To_Branch').change(function() {
                   loadDepartments($(this).val(), '#To_Department');
               });


           </script>


      </body>
 </html>



<!-- Add this data-keyboard="false" data-backdrop="static" to div below disables click away from modal closing of modal -->
 <div id="loginModal" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
      <div class="modal-dialog">
   <!-- Modal content-->
           <div class="modal-content">
                <div class="modal-header">

                     <h4 class="modal-title">LOGIN &nbsp;<small style="color:red">(For Managers only)</small></h4>
                     <button type="button" class="close" id="closeLoginModal"  data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body" align="left">

                   <form  id="login_Form" class="contact1-form"    method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" enctype="multipart/form-data" >
                     <p>
                       Please enter your Phoenix credentials below.
                     </p><br />
                     <p class="form-group">
                     <label>EmployeeID</label>
                     <input type="text" name="user" id="user" class="form-control"   pattern="[0-9]*"  required="required" />
                   </p>

                   <p class="form-group">
                     <label>Password</label>
                     <input type="password" name="pass" id="pass" class="form-control"  required="Required" />
                     <br />
                     <button type="submit" name="login_button"   id="login_button" class="contact1-form-btn">Login</button>
                   </p>
                     <!-- <br /> -->
                     <!-- Error Messages -->
                     <div class='alert alert-danger' id='errors' style="display:none">Please enter Manager's EmployeeID and Password</div>
                     <div class=' alert-danger' id='alertForm' style="display:none"></div>

                   </form>
                </div>
           </div>
      </div>
 </div>

 <div class="col-md-12">
   <!-- <?php echo $error; ?> -->
 </div>


 <script>

 // document.querySelector('#submit2').style.display = 'none';
 // ('#submit2').removeAttr('disabled', 'disabled');
 // document.querySelector('#submit3').addEventListener('click', showBtn);
 //
 // function showBtn(e) {
 //  // document.querySelector('#submit2').style.display = 'block';
 //   ('#submit2').attr('disabled', 'disabled');
 //  e.preventDefault();
 // }


 function HideContainerOne() {
   var x = document.getElementById("container-contact1");
   if (x.style.display === "block") {
     x.style.display = "none";
   // } else {
     // x.style.display = "none";
   }
 }




 $(document).ready(function(){

      $('#login_button').click(function(e){

           var user = $('#user').val().trim();
           var pass = $('#pass').val().trim();

           // Clear previous error messages before showing new ones
          $('#alertForm').empty().hide();  // Clear and hide alertForm
          $('#errors').hide();  // Hide the errors div


           if (user != '' && pass != '')
           {

                $.ajax({
                     url:"action.php",
                     method:"POST",
                     async: 'false',
                     cache: 'false',
                     data: {user:user, pass:pass},
                     // dataType:"text",
                     success:function(data){

                             if ((data.success)) {
                               // Open the modal explicitly
                               $('#container-contact2').modal('show');

                             } else {

                               document.getElementById('alertForm').style.display = "block";

                              // Display error from the response and fade out after 8 seconds
                              $('#alertForm').append(data).show().fadeOut(8000);
                              // $('#alertForm').append(data).show();


                             }
                     }
                });
                return false;
           }
           else {
             // Display error from the response and fade out after 8 seconds
             document.getElementById('errors').style.display='block'
             $('#errors').show().fadeOut(8000);
           }
      });

    });


// Logout function
// $(document).ready(function() {
//     $('#logout_button').click(function() {
//         // Close the modal if it's open
//         $('#successModal').modal('hide');
//
//         // Proceed with logout
//         window.location.href = "https://helpdesk.selectransportation.com/test.php"; // Redirect to logout page
//     });
// });


 </script>


 <!--===========================================All JS Files====================================================-->
    <!-- Jquery Library -->
    <!-- <script src="/helpdesk/vendor/jquery/jquery-3.2.1.min.js"></script> -->
    <!-- Main JS file -->
    <script src="/js/main.js"></script>


    <!-- Old Datepicker -->
    <!-- <script type= "text/javascript" src= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script> -->
    <!-- <link rel= "stylesheet" href= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/> -->

    <!-- New Datepicker and hide the jqery library above "/helpdesk/vendor/jquery/jquery-3.2.1.min.js"-->
    <!-- <script type= "text/javascript" src= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.1/js/bootstrap-datepicker.min.js"></script> -->
    <!-- <link rel= "stylesheet" href= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.1/css/bootstrap-datepicker.min.css"/> -->

 <!--===============================================================================================-->
