<?php
/* =========================================================
-- Author: Saquib Patwa
-- Create date: 02/17/2023
-- Last Modified on: N/A
-- Description: DISPLAYS PAN INFORMATION SO YOU CAN TRACK IT
-- =========================================================== */
session_start();

// To hide all errors
error_reporting(0);
ini_set('display_errors', 0);


if(isset($_SESSION["userid"]) && isset($_SESSION["hardcodedUser"]) && isset($_SESSION["loggedin_Activity"])) {
    // Check for timeout (e.g., 30 minutes)
    $timeout = 30 * 60; // 30 minutes in seconds
    $current_time = time();
    $last_activity_time = $_SESSION['loggedin_Activity'];

    // Calculate time difference
    $time_diff = $current_time - $last_activity_time;

    // Check if timeout exceeded
    if($time_diff > $timeout) {
        // Redirect to logout page or perform any other action
        header("Location: PANlogin.php");
        exit(); // Stop further execution
    }

    // Update last activity time
    $_SESSION['loggedin_Activity'] = $current_time;
} else {
    // User is not logged in, redirect to login page
    header("Location: PANlogin.php");
    exit(); // Stop further execution
}

?>

<script>
    // Set the timeout duration in milliseconds (e.g., 2 minutes = 2 * 60 * 1000 milliseconds)
    var timeoutDuration = 30 * 60 * 1000; // 30 minutes

    // Start the timeout countdown
    var timeoutTimer = setTimeout(function() {
        // Redirect to the login page when the timeout expires
        window.location.href = 'PANlogin.php';
    }, timeoutDuration);

    // Optionally, you can reset the timeout if there is user activity.
    // For example, you can reset the timeout when the user interacts with the page,
    // such as clicking a button or moving the mouse.
    document.addEventListener('mousemove', function() {
        // Reset the timeout
        clearTimeout(timeoutTimer);
        timeoutTimer = setTimeout(function() {
            // Redirect to the login page when the timeout expires
            window.location.href = 'PANlogin.php';
        }, timeoutDuration);
    });
    </script>

<!DOCTYPE html>
<html>
<head>
    <title>PAN TRACKING</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="cache-control" content="no-cache">

      <!-- Favicon & App Icon -->
      <!-- <link rel="icon" type="image/png" href="../../../helpdesk/Images/icons/help.ico" /> -->
      <!-- <link rel="shortcut icon" href="../../../helpdesk/Images/icons/help.ico" type="image/x-icon"/> -->

      <!--===============================================================================================-->
       <!-- This is to create an App Icon when you save to you website to your homescreen.
            Use the website www.favicon-generator.org/ to create an app icon and the code from the same website -->

            <link rel="apple-touch-icon" sizes="57x57" href="../helpdesk/Images/icons/Icons/apple-icon-57x57.png">
            <link rel="apple-touch-icon" sizes="60x60" href="../helpdesk/Images/icons/Icons/apple-icon-60x60.png">
            <link rel="apple-touch-icon" sizes="72x72" href="../helpdesk/Images/icons/Icons/apple-icon-72x72.png">
            <link rel="apple-touch-icon" sizes="76x76" href="../helpdesk/Images/icons/Icons/apple-icon-76x76.png">
            <link rel="apple-touch-icon" sizes="114x114" href="../helpdesk/Images/icons/Icons/apple-icon-114x114.png">
            <link rel="apple-touch-icon" sizes="120x120" href="../helpdesk/Images/icons/Icons/apple-icon-120x120.png">
            <link rel="apple-touch-icon" sizes="144x144" href="../helpdesk/Images/icons/Icons/apple-icon-144x144.png">
            <link rel="apple-touch-icon" sizes="152x152" href="../helpdesk/Images/icons/Icons/apple-icon-152x152.png">
            <link rel="apple-touch-icon" sizes="180x180" href="../helpdesk/Images/icons/Icons/apple-icon-180x180.png">
            <link rel="icon" type="image/png" sizes="192x192"  href="../helpdesk/Images/icons/Icons/android-icon-192x192.png">
            <link rel="icon" type="image/png" sizes="32x32" href="../helpdesk/Images/icons/Icons/favicon-32x32.png">
            <link rel="icon" type="image/png" sizes="96x96" href="../helpdesk/Images/icons/Icons/favicon-96x96.png">
            <link rel="icon" type="image/png" sizes="16x16" href="../helpdesk/Images/icons/Icons/favicon-16x16.png">
            <link rel="mask-icon" href="../helpdesk/Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
            <link rel="manifest" href="../helpdesk/Images/icons/Icons/manifest.json">
            <meta name="msapplication-TileColor" content="#ffffff">
            <meta name="msapplication-TileImage" content="../helpdesk/Images/icons/Icons/ms-icon-144x144.png">
            <meta name="theme-color" content="#ffffff">


      <!-- Bootstrap CSS -->
      <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
      <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">

      <!-- Sweet Alerts -->
      <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.3/sweetalert2.css">
      <script src="//cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/11.7.3/sweetalert2.min.js"></script>

      <!-- JQuery -->
      <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script> -->
      <script src="//ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
      <script type="text/javascript" src="https://code.jquery.com/jquery-3.4.1.min.js"></script>

      <!-- Bootstrap JS-->
      <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>


      <!-- Main CSS -->
      <link rel="stylesheet" href="../helpdesk/css/PANtrackDashboard.css"></link>

      <!-- Fonts from fonts.google.com-->
      <!-- <link href="https://fonts.googleapis.com/css?family=Lobster|Merriweather|Montserrat|Salsa&display=swap" rel="stylesheet"> -->

      <!-- Font Awesome -->
      <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css">


      <!-- DATATABLES -->
      <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css">
      <script src="//cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js"></script>

      <!--  Fixed Table Header -->
      <link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.3.1/css/fixedHeader.dataTables.min.css"></link>
      <script src="https://cdn.datatables.net/fixedheader/3.3.1/js/dataTables.fixedHeader.min.js"></script>


      <!-- Datatable Responsive -->
      <!-- <link rel="stylesheet" href="//cdn.datatables.net/fixedheader/3.3.2/css/fixedHeader.bootstrap.min.css"></link> -->
      <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.bootstrap.min.css"></link>
      <script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>




      <!-- <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css">

<script type="text/javascript" src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.20/js/dataTables.bootstrap4.min.js"></script> -->




<style>

/* Center the logo */
.navbar-brand {
    position: absolute;
    left: 50%;
    transform: translateX(-50%);

}

/* Style for the user dropdown */
.navbar .dropdown-menu {
    right: 0;
    left: auto;
}

/* Style for the title */
.title {
    text-align: center;
}


.LoginBtn{
    font-size: 16px;
    font-weight:bold;
}


</style>



</head>

<body>

  <!--<div  class="container-fluid">-->

  <!--<div class="row justify-content-center">-->
  <!--    <div  class="col-md-4 col-sm-12"></div>-->
  <!--    <div align="center" class="col-md-4" style="margin:20px auto; text-align: center;"><img src="../../..//helpdesk/Images/Logo-Main.png" alt="logo">-->
  <!--      <div align="center" class="col-md-12" ><h2>PAN TRACKING</h2></div>-->
  <!--    </div>-->

  <!--    <div  class="col-md-4 col-sm-12 LoginUser" style="margin:20px auto; text-align: right; font-size:.5rem !important; padding-bottom:-55px">-->

  <!--        <h4 ><strong>-->
  <!--          <?php echo strtoupper($_SESSION['hardcodedUser']); ?> &nbsp;&nbsp;&nbsp; <?php echo '<a href="PANlogout.php">LOGOUT</a>'; ?>-->
  <!--        </strong></h4>-->

  <!--    </div>-->
      <!-- <div align="center" class="col-md-12" ><h2>PAN TRACKING</h2></div> -->
  <!--</div>-->






<!--<nav class="navbar navbar-expand-2xl navbar-light bg-light">-->
<nav class="navbar navbar-expand-2xl navbar-light">
    <div class="container-fluid" align="center">
        <!-- Logo -->
        <a class="navbar-brand" href="#">
            <img src="../../../helpdesk/Images/Logo-Main.png" alt="logo" style="max-height: 90px; margin:0 auto">
        </a>

        <!-- User Dropdown -->
        <div class="ml-auto">
            <div class="dropdown">

                <!-- Small device button -->
                 <!--<button class="btn btn-light dropdown-toggle d-lg-none" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">-->
                <button class="btn  dropdown-toggle d-lg-none" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-user"></i>
                </button>

                <!-- large device logo -->
                 <!--<button class="btn btn-light d-none d-lg-block dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" >-->
                <button class="btn  d-none d-lg-block dropdown-toggle LoginBtn" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" >
                  <?php echo strtoupper($_SESSION['hardcodedUser']); ?>
                </button>

                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton">
                    <!-- <a class="dropdown-item" href="#">Profile</a> -->
                    <a class="dropdown-item" href="PANlogout.php">Logout</a>
                </div>

            </div>
        </div>
    </div>
</nav>


  <!-- Title -->
  <div class="container mt-5">
      <div class="row">
          <div class="col text-center">
              <h2>PAN TRACKING</h2>
          </div>
      </div>
  </div>

  <div class="container-fluid">

<table class="datatable table table-striped table-hover" id="dataList" class="display" style="width:100%; text-align:center">
    <thead style="position: sticky;top: 0;" class="thead-dark">
        <tr>
          <th scope="col" class="CenterColTitle">PAN ID</th>
          <th scope="col" class="CenterColTitle">SUBMITTED ON</th>
          <!-- <th scope="col">FORM TYPE</th> -->
          <th scope="col" class="CenterColTitle">EFFECTIVE DATE</th>
          <!-- <th scope="col">DEPARTMENT</th> -->
          <!-- <th scope="col">BRANCH</th> -->
          <th scope="col" class="CenterColTitle">SUBMITTED BY</th>
          <th scope="col" class="CenterColTitle">SENT TO VP FOR APPROVAL/REJECT</th>
          <th scope="col" class="CenterColTitle">PAN STATUS</th>
          <th scope="col" class="CenterColTitle">APPROVED/REJECTED ON</th>
        </tr>
    </thead>

    <!-- <tfoot>
        <tr>
        <th scope="col">No.</th>
        <th scope="col">REF ID</th>
        <th scope="col">SUBMITTED ON</th>
        <th scope="col">FORM TYPE</th>
        <th scope="col">EFFECTIVE DATE</th>
        <th scope="col">DEPARTMENT</th>
        <th scope="col">BRANCH</th>
        <th scope="col">SUBMITTED BY</th>
        <th scope="col">STATUS</th>
        <th scope="col">SENT TO VP FOR APPROVAL/REJECT</th>
        <th scope="col">APPROVED/REJECTED ON</th>
        </tr>
    </tfoot> -->
</table><br /><br />

</div>

<script>



// Initialize DataTables API object and configure table
var table = $('#dataList').DataTable({
    "processing": true,
    "serverSide": true,
    'order': [[0, 'desc']], //Sort in desc order using column 0 which is timestamp in this case
    'fixedHeader': true,
    'responsive': true,
    'rowReorder': {
         selector: 'td:nth-child(2)'
     },


     'lengthMenu': [[10, 25, 50, 100, 500, 700, -1], [10, 25, 50, 100, 500, 700, "All"]],
     // "iDisplayLength": 25,
     'columnDefs': [
           {
             "targets": [0, 4, 5, 6],
             "className": ' bolded',


          },
     			 // {"className": "dt-head-center", "targets": [0,1,2,3,4,5,6]}, //columnDefs for align text to center the header of datatable
     			 // {"className": "dt-body-center", "targets": [0,1,2,3,4,5,6]}  //columnDefs for align text to center the body of datatable

           {
             "targets": [5],
             // "className": 'bolded',
             "render": function(data, type, row, meta) {
                 if (data === "PENDING FOR APPROVAL") {
                     return '<span style="color: red; font-weight:bold">' + data + '</span>';
                 } else if (data === "APPROVED") {
                     return '<span style="color: green; font-weight:bold">' + data + '</span>';
                 } else if (data === "REJECTED") {
                     return '<span style="color: orange; font-weight:bold">' + data + '</span>';
                 } else {
                     return data;
                 }
               }
           },
     		 ],




         // Bolding the columns 0 {ID} and 6 {approved/rejected date}

               // "columnDefs": [
               //   {
               //     "targets": [0, 5, 6],
               //     className: 'bolded',
               //     "render": function(data, type, row, meta) {
               //         if (data === "PENDING FOR APPROVAL") {
               //             return '<span style="color: red; font-weight:bold">' + data + '</span>';
               //         } else if (data === "APPROVED") {
               //             return '<span style="color: green; font-weight:bold">' + data + '</span>';
               //         } else if (data === "REJECTED") {
               //             return '<span style="color: orange; font-weight:bold">' + data + '</span>';
               //         } else {
               //             return data;
               //         }
               //       }
               //   }
               // ],

    'ajax': "FetchData.php",
    // "columnDefs": [
    //     { "orderable": false, "targets": 0 }
    // ],

    // "columnDefs": [{
    //         "targets": [5], // Replace index_of_status_column with the index of your 'status' column
    //         "render": function(data, type, row, meta) {
    //             if (data === "PENDING FOR APPROVAL") {
    //                 return '<span style="color: red; font-weight:bold">' + data + '</span>';
    //             } else if (data === "APPROVED") {
    //                 return '<span style="color: green; font-weight:bold">' + data + '</span>';
    //             } else if (data === "REJECTED") {
    //                 return '<span style="color: orange; font-weight:bold">' + data + '</span>';
    //             } else {
    //                 return data;
    //             }
    //           }
    //         }],










    // clear X icon on search
    initComplete: function(settings) {
      //settings.nTable.id --> Get table ID
      $('#'+settings.nTable.id+'_filter input').wrap(`
        <div class="d-inline-flex position-relative"></div>
      `).after(`
        <button type="button" class="close position-absolute" aria-label="Close" style="right:5px; top:3px">
          <span aria-hidden="true">&times;</span>
        </button>
      `).attr('required','required').attr('title','Search');

      // Click Event on Clear button
      $(document).on('click', '#'+settings.nTable.id+'_filter button', function(){
         $('#'+settings.nTable.id).DataTable({
           "retrieve": true,
          }).search('').draw(); // reDraw table
      });
     }


});

// This below scripts adds Number columns automatically.
// table
//     .on('order.dt search.dt', function () {
//         let i = 1;
//
//         table
//             .cells(null, 0, { search: 'applied', order: 'applied' })
//             .every(function (cell) {
//                 this.data(i++);
//             });
//     })
//     .draw();

$(document).ready(function(){
    // Draw the table
    table.draw();
});



// Add data
// function addData(){
//     $('.frm-status').html('');
//     $('#userModalLabel').html('Add New User');
//
//     $('#Attendance_1').prop('checked', true);
//     $('#Attendance_2').prop('checked', false);
//     // $('#userStatus_1').prop('checked', true);
//     // $('#userStatus_2').prop('checked', false);
//     $('#Branch').val('');
//     $('#Type').val('');
//     $('#FirstName').val('');
//     $('#LastName').val('');
//     $('#EmpID').val('');
//     $('#GuestFirstName').val('');
//     $('#GuestLastName').val('');
//     $('#Email').val('');
//     $('#CellPhone').val('');
//     $('#CompanyName').val('');
//
//     $('#DataModal').modal('show');
// }
//
// // edit data
// function editData(user_data){
//     $('.frm-status').html('');
//     $('#userModalLabel').html('Edit User #'+user_data.RefNo);
//
//     if(user_data.Attendance == 'Yes, I will attend'){
//         $('#Attendance_1').prop('checked', false);
//         $('#Attendance_2').prop('checked', true);
//     }else{
//         $('#Attendance_1').prop('checked', false);
//         $('#Attendance_2').prop('checked', true);
//     }
//
//     // if(user_data.status == 1){
//     //     $('#userStatus_2').prop('checked', false);
//     //     $('#userStatus_1').prop('checked', true);
//     // }else{
//     //     $('#userStatus_1').prop('checked', false);
//     //     $('#userStatus_2').prop('checked', true);
//     // }
//
//     $('#Branch').val(user_data.Branch);
//     $('#Type').val(user_data.Type);
//     $('#FirstName').val(user_data.FirstName);
//     $('#LastName').val(user_data.LastName);
//     $('#EmpID').val(user_data.EmpID);
//     $('#GuestFirstName').val(user_data.GuestFirstName);
//     $('#GuestLastName').val(user_data.GuestLastName);
//     $('#Email').val(user_data.Email);
//     $('#CellPhone').val(user_data.CellPhone);
//     $('#CompanyName').val(user_data.CompanyName);
//     $('#RefNo').val(user_data.RefNo);
//     $('#DataModal').modal('show');
// }
//


// function submitUserData(){
//     $('.frm-status').html('');
//     let input_data_arr = [
//         // document.getElementById('PAN_ID').value,
//         // document.getElementById('timeStamp').value,
//         document.getElementById('FormType').value,
//         document.getElementById('effective_date').value,
//         document.getElementById('department').value,
//         document.getElementById('branch').value,
//         document.getElementById('fromName').value,
//         document.getElementById('Approval_Status').value,
//         document.getElementById('ApprovedOn').value,
//
//
//         document.getElementById('PAN_ID').value,
//     ];
//
//     fetch("eventHandler.php", {
//         method: "POST",
//         headers: { "Content-Type": "application/json" },
//         body: JSON.stringify({ request_type:'addEditUser', user_data: input_data_arr}),
//     })
//     .then(response => response.json())
//     .then(data => {
//         if (data.status == 1) {
//             Swal.fire({
//                 title: data.msg,
//                 icon: 'success',
//             }).then((result) => {
//                 // Redraw the table
// 	        table.draw();
//
//                 $('#userDataModal').modal('hide');
//                 $("#userDataFrm")[0].reset();
//             });
//         } else {
//             $('.frm-status').html('<div class="alert alert-danger" role="alert">'+data.error+'</div>');
//         }
//     })
//     .catch(console.error);
// }
//
//


//  Delete DATA

// function deleteData(RefNo){
//     Swal.fire({
//         title: 'Are you sure to Delete?',
//         text:'You won\'t be able to revert this!',
//         icon: 'warning',
//         showCancelButton: true,
//         confirmButtonColor: '#3085d6',
//         cancelButtonColor: '#d33',
//         confirmButtonText: 'Yes, delete it!'
//       }).then((result) => {
//         if (result.isConfirmed) {
//           // Delete event
//           fetch("eventHandler.php", {
//             method: "POST",
//             headers: { "Content-Type": "application/json" },
//             body: JSON.stringify({ request_type:'deleteUser', RefNo: RefNo}),
//           })
//           .then(response => response.json())
//           .then(data => {
//             if (data.status == 1) {
//                 Swal.fire({
//                     title: data.msg,
//                     icon: 'success',
//                 }).then((result) => {
//                     table.draw();
//                 });
//             } else {
//               Swal.fire(data.error, '', 'error');
//             }
//           })
//           .catch(console.error);
//         } else {
//           Swal.close();
//         }
//     });
// }


</script>



</body>
</html>
